/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.pitest.maven.report.AbstractPitAggregationReportMojo;

@Mojo(name="report-aggregate", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class PitAggregationMojo
extends AbstractPitAggregationReportMojo {
    @Override
    public String getDescription(Locale locale) {
        return this.getName(locale) + " Coverage Report.";
    }

    List<MavenProject> findDependencies() {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        List<String> scopeList = Arrays.asList("compile", "runtime", "provided", "test");
        for (Object dependencyObject : this.getProject().getDependencies()) {
            MavenProject project;
            Dependency dependency = (Dependency)dependencyObject;
            if (!scopeList.contains(dependency.getScope()) || (project = this.findProjectFromReactor(dependency)) == null) continue;
            result.add(project);
        }
        return result;
    }

    private MavenProject findProjectFromReactor(Dependency d) {
        for (MavenProject p : this.reactorProjects) {
            if (!p.getGroupId().equals(d.getGroupId()) || !p.getArtifactId().equals(d.getArtifactId()) || !p.getVersion().equals(d.getVersion())) continue;
            return p;
        }
        return null;
    }
}

