/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.util;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIOutput;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import org.primefaces.config.PrimeEnvironment;
import org.primefaces.context.PrimeApplicationContext;

public class ResourceExtUtils {
    public static final String RENDERER_TYPE_CSS = "jakarta.faces.resource.Stylesheet";
    public static final String RENDERER_TYPE_JS = "jakarta.faces.resource.Script";
    private static final String MYFACES_RESOURCE_DEPENDENCY_UNIQUE_ID = "oam.view.resourceDependencyUniqueId";

    public static void addJavascriptResource(FacesContext context, String libraryName, String resourceName) {
        ResourceExtUtils.addResource(context, RENDERER_TYPE_JS, libraryName, resourceName);
    }

    public static void addCssResource(FacesContext context, String libraryName, String resourceName) {
        ResourceExtUtils.addResource(context, RENDERER_TYPE_CSS, libraryName, resourceName);
    }

    public static void addResource(FacesContext context, String type, String libraryName, String resourceName) {
        if (!context.getApplication().getResourceHandler().isResourceRendered(context, resourceName, libraryName)) {
            ResourceExtUtils.addScriptResourceToHead(context, type, libraryName, resourceName);
        }
    }

    private static UIComponent addScriptResourceToTarget(FacesContext context, String type, String libraryName, String resourceName, String target) {
        String id = (String)(libraryName != null ? libraryName.replaceAll("\\W+", "_") + "_" : "") + resourceName.replaceAll("\\W+", "_");
        for (UIComponent existingResource : context.getViewRoot().getComponentResources(context)) {
            if (!id.equals(existingResource.getId())) continue;
            return existingResource;
        }
        UIOutput outputScript = ResourceExtUtils.createScriptResource(type);
        outputScript.setId(id);
        if (libraryName != null) {
            outputScript.getAttributes().put("library", libraryName);
        }
        outputScript.getAttributes().put("name", resourceName);
        return ResourceExtUtils.addComponentResource(context, (UIComponent)outputScript, target);
    }

    private static UIOutput createScriptResource(String type) {
        UIOutput outputScript = new UIOutput();
        outputScript.setRendererType(type);
        return outputScript;
    }

    private static void addScriptResourceToHead(FacesContext context, String type, String libraryName, String resourceName) {
        ResourceExtUtils.addScriptResourceToTarget(context, type, libraryName, resourceName, "head");
    }

    private static void addScriptResourceToBody(FacesContext context, String type, String libraryName, String resourceName) {
        ResourceExtUtils.addScriptResourceToTarget(context, type, libraryName, resourceName, "body");
    }

    private static UIComponent addComponentResource(FacesContext context, UIComponent resource, String target) {
        if (resource.getId() == null) {
            ResourceExtUtils.setComponentResourceUniqueId(context, resource);
        }
        context.getViewRoot().addComponentResource(context, resource, target);
        return resource;
    }

    public static void addScriptToBody(FacesContext context, String script) {
        ResourceExtUtils.addScriptToTarget(context, script, "body");
    }

    public static void addScriptToHead(FacesContext context, String script) {
        ResourceExtUtils.addScriptToTarget(context, script, "head");
    }

    public static void addScriptToTarget(FacesContext context, String script, String target) {
        UIOutput outputScript = ResourceExtUtils.createScriptResource(RENDERER_TYPE_JS);
        UIOutput content = new UIOutput();
        content.setValue((Object)script);
        outputScript.getChildren().add(content);
        ResourceExtUtils.addComponentResource(context, (UIComponent)outputScript, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setComponentResourceUniqueId(FacesContext context, UIComponent resource) {
        boolean isMyFacesUsed;
        UIViewRoot view = context.getViewRoot();
        PrimeEnvironment environment = PrimeApplicationContext.getCurrentInstance((FacesContext)context).getEnvironment();
        boolean bl = isMyFacesUsed = !environment.isMojarra();
        if (isMyFacesUsed) {
            view.getAttributes().put(MYFACES_RESOURCE_DEPENDENCY_UNIQUE_ID, Boolean.TRUE);
        }
        try {
            resource.setId(view.createUniqueId(context, null));
        }
        finally {
            if (isMyFacesUsed) {
                view.getAttributes().put(MYFACES_RESOURCE_DEPENDENCY_UNIQUE_ID, Boolean.FALSE);
            }
        }
    }
}

