/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.client;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Level;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.lang3.ClassUtils;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.ClientInfo;
import org.restlet.data.Cookie;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.application.StatusInfo;
import org.restlet.engine.resource.AnnotationUtils;
import org.restlet.engine.resource.ClientInvocationHandler;
import org.restlet.engine.resource.MethodAnnotationInfo;
import org.restlet.engine.resource.ThrowableAnnotationInfo;
import org.restlet.engine.util.StringUtils;
import org.restlet.ext.jaxrs.internal.client.JaxRsAnnotationUtils;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientProxy;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Result;
import org.restlet.util.Series;

@Deprecated
public class JaxRsClientInvocationHandler<T>
extends ClientInvocationHandler<T> {
    private ClientResource clientResource;

    public JaxRsClientInvocationHandler(ClientResource clientResource, Class<? extends T> resourceInterface) {
        super(clientResource, resourceInterface, (AnnotationUtils)JaxRsAnnotationUtils.getInstance());
        this.clientResource = clientResource;
    }

    private void addCookieParam(Request request, String representationAsText, Annotation annotation) {
        Series cookies = request.getCookies();
        if (cookies == null) {
            cookies = new Series(Cookie.class);
        }
        cookies.add((Object)new Cookie(((CookieParam)annotation).value(), representationAsText));
        request.setCookies(cookies);
    }

    private void addFormParam(Form form, String representationAsText, Annotation annotation) {
        form.add((Object)new Parameter(((FormParam)annotation).value(), representationAsText));
    }

    private void addHeaderParam(Request request, String representationAsText, Annotation annotation) {
        Util.getHttpHeaders(request).add(((HeaderParam)annotation).value(), representationAsText);
    }

    private void addPathParam(Request request, String representationAsText, Annotation annotation) {
        String paramName = ((PathParam)annotation).value();
        String existingPath = Reference.decode((String)request.getResourceRef().getPath());
        String simplePathParam = String.format("{%s}", paramName);
        if (existingPath.contains(simplePathParam)) {
            existingPath = existingPath.replace(simplePathParam, Reference.encode((String)representationAsText));
        }
        request.getResourceRef().setPath(existingPath);
    }

    private void addQueryParam(Request request, String representationAsText, Annotation annotation) {
        request.getResourceRef().addQueryParameter(new Parameter(((QueryParam)annotation).value(), representationAsText));
    }

    private String getRepresentationAsText(Object value) {
        boolean isPrimitiveOrWrapped;
        Class<?> clazz = value.getClass();
        boolean bl = isPrimitiveOrWrapped = clazz.isPrimitive() || ClassUtils.wrapperToPrimitive(clazz) != null;
        if (isPrimitiveOrWrapped || clazz == String.class) {
            return String.valueOf(value);
        }
        String representationAsText = null;
        try {
            Representation representation = this.clientResource.getApplication().getConverterService().toRepresentation(value);
            representationAsText = representation.getText();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e);
        }
        return representationAsText;
    }

    protected Request getRequest(Method javaMethod, Object[] args) throws Throwable {
        Request request = super.getRequest(javaMethod, args);
        this.setRequestPathToAnnotationPath(javaMethod, request);
        return request;
    }

    private void handleJavaMethodParameter(Request request, Object value, Type genericParameterType, Annotation[] annotations, Form form) throws IOException {
        if (value == null) {
            request.setEntity(null);
        } else if (Result.class.isAssignableFrom(value.getClass())) {
            final Result rCallback = (Result)value;
            ParameterizedType parameterizedType = genericParameterType instanceof ParameterizedType ? (ParameterizedType)genericParameterType : null;
            final Class actualType = parameterizedType != null && parameterizedType.getActualTypeArguments()[0] instanceof Class ? (Class)parameterizedType.getActualTypeArguments()[0] : null;
            Uniform callback = new Uniform(){

                public void handle(Request request, Response response) {
                    if (response.getStatus().isError()) {
                        rCallback.onFailure((Throwable)new ResourceException(response.getStatus()));
                    } else if (actualType != null) {
                        Object result = null;
                        try {
                            result = JaxRsClientInvocationHandler.this.getClientResource().toObject(response.getEntity(), actualType);
                            rCallback.onSuccess(result);
                        }
                        catch (Exception e) {
                            rCallback.onFailure((Throwable)new ResourceException((Throwable)e));
                        }
                    } else {
                        rCallback.onSuccess(null);
                    }
                }
            };
            this.getClientResource().setOnResponse(callback);
        } else if (annotations != null && annotations.length > 0) {
            String representationAsText = this.getRepresentationAsText(value);
            if (representationAsText != null) {
                for (Annotation annotation : annotations) {
                    if (annotation instanceof HeaderParam) {
                        this.addHeaderParam(request, representationAsText, annotation);
                        continue;
                    }
                    if (annotation instanceof QueryParam) {
                        this.addQueryParam(request, representationAsText, annotation);
                        continue;
                    }
                    if (annotation instanceof FormParam) {
                        this.addFormParam(form, representationAsText, annotation);
                        continue;
                    }
                    if (annotation instanceof CookieParam) {
                        this.addCookieParam(request, representationAsText, annotation);
                        continue;
                    }
                    if (annotation instanceof MatrixParam || !(annotation instanceof PathParam)) continue;
                    this.addPathParam(request, representationAsText, annotation);
                }
            }
        } else {
            request.setEntity(this.getClientResource().toRepresentation(value));
        }
    }

    public Object invoke(Object proxy, Method javaMethod, Object[] args) throws Throwable {
        Object result = null;
        if (javaMethod.equals(Object.class.getMethod("toString", new Class[0]))) {
            result = "ClientProxy for resource: " + this.clientResource;
        } else if (javaMethod.equals(ClientProxy.class.getMethod("getClientResource", new Class[0]))) {
            result = this.clientResource;
        } else {
            List responseVariants;
            MethodAnnotationInfo annotationInfo = this.getAnnotationUtils().getMethodAnnotation(this.getAnnotations(), javaMethod);
            if (annotationInfo == null) {
                return result;
            }
            Request request = this.getRequest(javaMethod, args);
            if (args != null && args.length > 0) {
                Form form = new Form();
                Annotation[][] parameterAnnotations = javaMethod.getParameterAnnotations();
                Type[] genericParameterTypes = javaMethod.getGenericParameterTypes();
                for (int i = 0; i < args.length; ++i) {
                    Object o = args[i];
                    Type genericParameterType = genericParameterTypes[i];
                    this.handleJavaMethodParameter(request, o, genericParameterType, parameterAnnotations[i], form);
                }
                if (!form.isEmpty()) {
                    request.setEntity(form.getWebRepresentation());
                }
            }
            request.setMethod(annotationInfo.getRestletMethod());
            String query = annotationInfo.getQuery();
            if (query != null) {
                Form queryParams = new Form(annotationInfo.getQuery());
                request.getResourceRef().addQueryParameters((Iterable)queryParams);
            }
            if (request.getClientInfo().getAcceptedCharacterSets().isEmpty() && request.getClientInfo().getAcceptedEncodings().isEmpty() && request.getClientInfo().getAcceptedLanguages().isEmpty() && request.getClientInfo().getAcceptedMediaTypes().isEmpty() && (responseVariants = annotationInfo.getResponseVariants(this.getClientResource().getMetadataService(), this.getClientResource().getConverterService())) != null) {
                request.setClientInfo(new ClientInfo(responseVariants));
            }
            Response response = this.getClientResource().handleOutbound(request);
            if (this.getClientResource().getOnResponse() == null) {
                if (response != null && response.getStatus().isError()) {
                    ThrowableAnnotationInfo tai = this.getAnnotationUtils().getThrowableAnnotationInfo(javaMethod, response.getStatus().getCode());
                    if (tai != null) {
                        Class throwableClazz = tai.getJavaClass();
                        Throwable t = null;
                        if (tai.isSerializable() && response.isEntityAvailable()) {
                            t = (Throwable)this.getClientResource().toObject(response.getEntity(), throwableClazz);
                        } else {
                            StatusInfo si;
                            try {
                                t = (Throwable)throwableClazz.newInstance();
                            }
                            catch (Exception e) {
                                Context.getCurrentLogger().log(Level.FINE, "Unable to instantiate the client-side exception using the default constructor.");
                            }
                            if (response.isEntityAvailable() && (si = (StatusInfo)this.getClientResource().toObject(response.getEntity(), StatusInfo.class)) != null) {
                                response.setStatus(new Status(si.getCode(), si.getReasonPhrase(), si.getDescription()));
                            }
                        }
                        if (t != null) {
                            throw t;
                        }
                    }
                    this.getClientResource().doError(response.getStatus());
                } else if (!annotationInfo.getJavaOutputType().equals(Void.TYPE)) {
                    result = this.getClientResource().toObject(response == null ? null : response.getEntity(), annotationInfo.getJavaOutputType());
                }
            }
        }
        return result;
    }

    private void setRequestPathToAnnotationPath(Method javaMethod, Request request) {
        String methodPath;
        Path methodPathAnnotation = javaMethod.getAnnotation(Path.class);
        if (methodPathAnnotation != null && !StringUtils.isNullOrEmpty((String)(methodPath = methodPathAnnotation.value()))) {
            String fullUriFromPath = request.getResourceRef().getPath();
            fullUriFromPath = fullUriFromPath.endsWith("/") ? (methodPath.startsWith("/") ? fullUriFromPath + methodPath.substring(1) : fullUriFromPath + methodPath) : (methodPath.startsWith("/") ? fullUriFromPath + methodPath : fullUriFromPath + "/" + methodPath);
            request.getResourceRef().setPath(fullUriFromPath);
        }
    }
}

