/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.restlet.Context;
import org.restlet.ext.jaxrs.internal.provider.AbstractJaxbProvider;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

@Deprecated
@Provider
@Produces(value={"application/xml", "text/xml", "application/*+xml"})
@Consumes(value={"application/xml", "text/xml", "application/*+xml"})
public class JaxbProvider
extends AbstractJaxbProvider<Object> {
    private volatile boolean expandingEntityRefs = false;
    private final Logger logger = Context.getCurrentLogger();
    private boolean secureProcessing = true;
    private volatile boolean validatingDtd = false;
    private volatile boolean xIncludeAware = false;

    @Override
    Logger getLogger() {
        return this.logger;
    }

    public boolean isExpandingEntityRefs() {
        return this.expandingEntityRefs;
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAnnotationPresent(XmlRootElement.class);
    }

    public boolean isSecureProcessing() {
        return this.secureProcessing;
    }

    public boolean isValidatingDtd() {
        return this.validatingDtd;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAnnotationPresent(XmlRootElement.class);
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setXIncludeAware(this.isXIncludeAware());
            spf.setNamespaceAware(true);
            spf.setValidating(this.isValidatingDtd());
            spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", this.isSecureProcessing());
            spf.setFeature("http://xml.org/sax/features/external-general-entities", this.isExpandingEntityRefs());
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", this.isExpandingEntityRefs());
            XMLReader reader = spf.newSAXParser().getXMLReader();
            JAXBContext jaxbContext = this.getJaxbContext(type);
            Unmarshaller um = jaxbContext.createUnmarshaller();
            return um.unmarshal((Source)new SAXSource(reader, new InputSource(entityStream)));
        }
        catch (Exception e) {
            throw new IOException("Could not unmarshal to " + type.getName(), e);
        }
    }

    public void setExpandingEntityRefs(boolean expandEntityRefs) {
        this.expandingEntityRefs = expandEntityRefs;
    }

    public void setSecureProcessing(boolean secureProcessing) {
        this.secureProcessing = secureProcessing;
    }

    public void setValidatingDtd(boolean validating) {
        this.validatingDtd = validating;
    }

    public void setXIncludeAware(boolean includeAware) {
        this.xIncludeAware = includeAware;
    }

    @Override
    public void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpResponseHeaders, OutputStream entityStream) throws IOException {
        this.marshal(object, entityStream);
    }
}

