/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.provider;

import java.util.Collection;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.ExceptionMapper;
import org.restlet.Application;
import org.restlet.ext.jaxrs.ExtendedUriBuilder;
import org.restlet.ext.jaxrs.ExtendedUriInfo;
import org.restlet.ext.jaxrs.internal.exceptions.NotAcceptableWebAppException;
import org.restlet.ext.jaxrs.internal.exceptions.UnsupportedMediaTypeWebAppException;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ExtensionBackwardMapping;

@Deprecated
public class WebAppExcMapper
implements ExceptionMapper<WebApplicationException> {
    @Context
    private ExtensionBackwardMapping extBackwMapping;
    @Context
    private HttpHeaders httpHeaders;
    @Context
    private ExtendedUriInfo uriInfo;

    private boolean addExtensions(ExtendedUriBuilder uriBuilder, Variant variant) {
        ((Object)((Object)uriBuilder)).equals(null);
        String mediaTypeExt = null;
        String languageExt = null;
        String encodingExt = null;
        if (variant.getMediaType() != null && (mediaTypeExt = this.extBackwMapping.getByMediaType(variant.getMediaType())) == null) {
            return false;
        }
        if (variant.getLanguage() != null && (languageExt = this.extBackwMapping.getByLanguage(variant.getLanguage())) == null) {
            languageExt = Converter.toLanguageString(variant.getLanguage());
        }
        if (variant.getEncoding() != null && (encodingExt = this.extBackwMapping.getByEncoding(variant.getEncoding())) == null) {
            encodingExt = variant.getEncoding();
        }
        if (languageExt != null) {
            uriBuilder.extensionLanguage(languageExt);
        }
        if (mediaTypeExt != null) {
            uriBuilder.extensionMedia(mediaTypeExt);
        }
        if (encodingExt != null) {
            uriBuilder.queryParam(Application.getCurrent().getTunnelService().getEncodingParameter(), encodingExt);
        }
        return true;
    }

    private Collection<Variant> getAcceptedVariants(WebApplicationException wae) {
        if (wae instanceof UnsupportedMediaTypeWebAppException) {
            return ((UnsupportedMediaTypeWebAppException)wae).getAccepted();
        }
        return null;
    }

    private Collection<Variant> getSupportedVariants(WebApplicationException wae) {
        if (wae instanceof NotAcceptableWebAppException) {
            return ((NotAcceptableWebAppException)wae).getSupported();
        }
        return null;
    }

    private Response giveOtherVariant(Collection<Variant> acceptedVariants, Response response) {
        if (acceptedVariants != null && acceptedVariants.isEmpty()) {
            acceptedVariants = null;
        }
        Response.ResponseBuilder rb = Response.fromResponse((Response)response);
        StringBuilder stb = new StringBuilder();
        stb.append("The given resource variant is not supported.");
        if (acceptedVariants != null) {
            stb.append("Please use one of the following:\n");
            stb.append("\n");
            for (Variant variant : acceptedVariants) {
                stb.append("* ");
                stb.append(variant);
                stb.append("\n");
            }
        }
        rb.entity((Object)stb);
        rb.type(MediaType.TEXT_PLAIN_TYPE);
        return rb.build();
    }

    private Response requestOtherVariants(Collection<Variant> supportedVariants, Response response) {
        if (supportedVariants != null && supportedVariants.isEmpty()) {
            supportedVariants = null;
        }
        Response.ResponseBuilder rb = Response.fromResponse((Response)response);
        boolean xhtml = false;
        boolean html = this.httpHeaders.getAcceptableMediaTypes().contains(MediaType.TEXT_HTML_TYPE);
        if (!html) {
            html = xhtml = this.httpHeaders.getAcceptableMediaTypes().contains(MediaType.APPLICATION_XHTML_XML_TYPE);
        }
        StringBuilder stb = new StringBuilder();
        if (html) {
            stb.append("<html><head>\n");
            stb.append("<title>The requested variant is not available</title>");
            stb.append("\n</head>\n<body>\n<p>\n");
        }
        stb.append("The requested variant is not available.");
        if (supportedVariants != null) {
            stb.append(" Try one of the following:\n");
            if (html) {
                stb.append("</p><ul>");
            }
            stb.append("\n");
            for (Variant variant : supportedVariants) {
                ExtendedUriBuilder uriBuilder = this.uriInfo.getRequestUriBuilder();
                boolean added = this.addExtensions(uriBuilder, variant);
                if (!added) continue;
                String uri = uriBuilder.build(new Object[0]).toString();
                if (html) {
                    stb.append("<li><a href=\"");
                } else {
                    stb.append("* ");
                }
                stb.append(uri);
                if (html) {
                    stb.append("\">");
                    stb.append(uri);
                    stb.append("</a></li>");
                }
                stb.append("\n");
            }
            if (html) {
                stb.append("</ul>");
            }
        }
        if (html) {
            stb.append("</body></html>");
        }
        rb.entity((Object)stb);
        if (xhtml) {
            rb.type(MediaType.APPLICATION_XHTML_XML_TYPE);
        } else if (html) {
            rb.type(MediaType.TEXT_HTML_TYPE);
        } else {
            rb.type(MediaType.TEXT_PLAIN_TYPE);
        }
        return rb.build();
    }

    public Response toResponse(WebApplicationException wae) {
        Response response = wae.getResponse();
        if (response == null) {
            return null;
        }
        if (response.getEntity() != null) {
            return response;
        }
        if (response.getStatus() == Response.Status.NOT_ACCEPTABLE.getStatusCode()) {
            return this.requestOtherVariants(this.getSupportedVariants(wae), response);
        }
        if (response.getStatus() == Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode()) {
            return this.giveOtherVariant(this.getAcceptedVariants(wae), response);
        }
        return response;
    }
}

