/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.ext.jaxrs.internal.core.CallContext;
import org.restlet.ext.jaxrs.internal.util.MatchingResult;
import org.restlet.ext.jaxrs.internal.util.OrderedMap;
import org.restlet.ext.jaxrs.internal.util.PathRegExp;
import org.restlet.ext.jaxrs.internal.util.SortedMetadata;
import org.restlet.ext.jaxrs.internal.util.SortedOrderedBag;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceMethod;
import org.restlet.ext.jaxrs.internal.wrappers.RrcOrRml;
import org.restlet.ext.jaxrs.internal.wrappers.SubResourceLocator;

@Deprecated
public class AlgorithmUtil {
    private static Comparator<ResourceMethod> COMP = new Comparator<ResourceMethod>(){

        @Override
        public int compare(ResourceMethod rm1, ResourceMethod rm2) {
            int nndre1 = rm1.getPathRegExp().getNoNonDefCaprGroups();
            int nndre2 = rm2.getPathRegExp().getNoNonDefCaprGroups();
            return nndre2 - nndre1;
        }
    };

    public static void addPathVarsToMap(MatchingResult matchResult, CallContext callContext) {
        Map<String, String> variables = matchResult.getVariables();
        for (Map.Entry<String, String> varEntry : variables.entrySet()) {
            String key = varEntry.getKey();
            String value = varEntry.getValue();
            callContext.addPathParamsEnc(key, value);
        }
    }

    private static OrderedMap<ResourceMethod, List<MediaType>> findMethodsSupportAllTypes(Collection<ResourceMethod> resourceMethods, ConsOrProdMime inOut) {
        OrderedMap<ResourceMethod, List<MediaType>> returnMethods = new OrderedMap<ResourceMethod, List<MediaType>>();
        for (ResourceMethod resourceMethod : resourceMethods) {
            List<MediaType> mimes = AlgorithmUtil.getConsOrProdMimes(resourceMethod, inOut);
            for (MediaType resMethMediaType : mimes) {
                if (!resMethMediaType.equals((Object)MediaType.ALL)) continue;
                returnMethods.put(resourceMethod, mimes);
            }
        }
        return returnMethods;
    }

    private static OrderedMap<ResourceMethod, List<MediaType>> findMethodsSupportType(Collection<ResourceMethod> resourceMethods, ConsOrProdMime inOut, SortedMetadata<MediaType> mediaTypes) {
        OrderedMap<ResourceMethod, List<MediaType>> returnMethods = new OrderedMap<ResourceMethod, List<MediaType>>();
        for (ResourceMethod resourceMethod : resourceMethods) {
            List<MediaType> mimes = AlgorithmUtil.getConsOrProdMimes(resourceMethod, inOut);
            for (MediaType resMethMediaType : mimes) {
                for (MediaType mediaType : mediaTypes) {
                    String wishedMainType;
                    String resMethMainType = resMethMediaType.getMainType();
                    if (!resMethMainType.equals(wishedMainType = mediaType.getMainType())) continue;
                    returnMethods.put(resourceMethod, mimes);
                }
            }
        }
        return returnMethods;
    }

    private static OrderedMap<ResourceMethod, List<MediaType>> findMethodsSupportTypeAndSubType(Collection<ResourceMethod> resourceMethods, ConsOrProdMime inOut, SortedMetadata<MediaType> mediaTypes) {
        OrderedMap<ResourceMethod, List<MediaType>> returnMethods = new OrderedMap<ResourceMethod, List<MediaType>>();
        for (ResourceMethod resourceMethod : resourceMethods) {
            List<MediaType> mimes = AlgorithmUtil.getConsOrProdMimes(resourceMethod, inOut);
            for (MediaType resMethMediaType : mimes) {
                for (MediaType mediaType : mediaTypes) {
                    if (!resMethMediaType.equals((Object)mediaType, true)) continue;
                    returnMethods.put(resourceMethod, mimes);
                }
            }
        }
        return returnMethods;
    }

    private static OrderedMap<ResourceMethod, List<MediaType>> findMethodSupportsMime(Collection<ResourceMethod> resourceMethods, ConsOrProdMime inOut, SortedMetadata<MediaType> mediaTypes) {
        if (mediaTypes == null || mediaTypes.isEmpty()) {
            return AlgorithmUtil.findMethodsSupportAllTypes(resourceMethods, inOut);
        }
        OrderedMap<ResourceMethod, List<MediaType>> mms = AlgorithmUtil.findMethodsSupportTypeAndSubType(resourceMethods, inOut, mediaTypes);
        if (mms.isEmpty() && (mms = AlgorithmUtil.findMethodsSupportType(resourceMethods, inOut, mediaTypes)).isEmpty()) {
            mms = AlgorithmUtil.findMethodsSupportAllTypes(resourceMethods, inOut);
        }
        return mms;
    }

    public static ResourceMethod getBestMethod(Collection<ResourceMethod> unsortedResourceMethods, MediaType givenMediaType, SortedMetadata<MediaType> accMediaTypes, Method requHttpMethod) {
        SortedOrderedBag<ResourceMethod> resourceMethods = new SortedOrderedBag<ResourceMethod>(COMP, unsortedResourceMethods);
        SortedMetadata<MediaType> givenMediaTypes = givenMediaType != null ? SortedMetadata.singleton(givenMediaType) : null;
        OrderedMap<ResourceMethod, List<MediaType>> mms1 = AlgorithmUtil.findMethodSupportsMime(resourceMethods, ConsOrProdMime.CONSUME_MIME, givenMediaTypes);
        if (mms1.size() == 1) {
            return Util.getFirstKey(mms1);
        }
        if (mms1.isEmpty()) {
            return Util.getFirstElement(resourceMethods);
        }
        OrderedMap<ResourceMethod, List<MediaType>> mms2 = AlgorithmUtil.findMethodSupportsMime(mms1.keySet(), ConsOrProdMime.PRODUCE_MIME, accMediaTypes);
        if (mms2.size() == 1) {
            return Util.getFirstKey(mms2);
        }
        if (mms2.isEmpty()) {
            return Util.getFirstKey(mms1);
        }
        for (MediaType accMediaType : accMediaTypes) {
            ResourceMethod bestResMethod = null;
            for (Map.Entry mm : mms2.entrySet()) {
                for (MediaType methodMediaType : (List)mm.getValue()) {
                    Method bestMethodHttp;
                    if (!accMediaType.includes((Metadata)methodMediaType)) continue;
                    ResourceMethod currentResMethod = (ResourceMethod)mm.getKey();
                    if (bestResMethod == null) {
                        bestResMethod = currentResMethod;
                        continue;
                    }
                    if (!requHttpMethod.equals((Object)Method.HEAD) || (bestMethodHttp = bestResMethod.getHttpMethod()).equals((Object)Method.GET) && currentResMethod.getHttpMethod().equals((Object)Method.HEAD) || !bestMethodHttp.equals((Object)Method.HEAD) || !currentResMethod.getHttpMethod().equals((Object)Method.GET)) continue;
                    bestResMethod = currentResMethod;
                }
            }
            if (bestResMethod == null) continue;
            return bestResMethod;
        }
        return Util.getFirstKey(mms2);
    }

    private static List<MediaType> getConsOrProdMimes(ResourceMethod resourceMethod, ConsOrProdMime inOut) {
        if (inOut.equals((Object)ConsOrProdMime.CONSUME_MIME)) {
            return resourceMethod.getConsumedMimes();
        }
        List<MediaType> producedMimes = resourceMethod.getProducedMimes();
        if (producedMimes.isEmpty()) {
            return Util.createList(MediaType.ALL);
        }
        return producedMimes;
    }

    public static <R extends RrcOrRml> R getFirstByNoOfLiteralCharsNoOfCapturingGroups(Collection<R> rrcOrRmls) {
        if (rrcOrRmls == null || rrcOrRmls.isEmpty()) {
            return null;
        }
        Iterator<R> srmlIter = rrcOrRmls.iterator();
        RrcOrRml bestSrml = (RrcOrRml)srmlIter.next();
        if (rrcOrRmls.size() == 1) {
            return (R)bestSrml;
        }
        int bestSrmlChars = Integer.MIN_VALUE;
        int bestSrmlNoCaptGroups = Integer.MIN_VALUE;
        int bestSrmlNoNonDefCaptGroups = Integer.MIN_VALUE;
        for (RrcOrRml srml : rrcOrRmls) {
            PathRegExp srmlRegExp = srml.getPathRegExp();
            int srmlNoLitChars = srmlRegExp.getNoOfLiteralChars();
            int srmlNoCaptGroups = srmlRegExp.getNoOfCapturingGroups();
            int srmlNoNonDefCaptGroups = srmlRegExp.getNoNonDefCaprGroups();
            if (srmlNoLitChars > bestSrmlChars) {
                bestSrml = srml;
                bestSrmlChars = srmlNoLitChars;
                bestSrmlNoCaptGroups = srmlNoCaptGroups;
                bestSrmlNoNonDefCaptGroups = srmlNoNonDefCaptGroups;
                continue;
            }
            if (srmlNoLitChars != bestSrmlChars) continue;
            if (srmlNoCaptGroups > bestSrmlNoCaptGroups) {
                bestSrml = srml;
                bestSrmlChars = srmlNoLitChars;
                bestSrmlNoCaptGroups = srmlNoCaptGroups;
                bestSrmlNoNonDefCaptGroups = srmlNoNonDefCaptGroups;
                continue;
            }
            if (srmlNoCaptGroups != bestSrmlNoCaptGroups) continue;
            if (srmlNoNonDefCaptGroups > bestSrmlNoNonDefCaptGroups) {
                bestSrml = srml;
                bestSrmlChars = srmlNoLitChars;
                bestSrmlNoCaptGroups = srmlNoCaptGroups;
                bestSrmlNoNonDefCaptGroups = srmlNoNonDefCaptGroups;
                continue;
            }
            if (srmlNoNonDefCaptGroups != bestSrmlNoNonDefCaptGroups || !(srml instanceof ResourceMethod) || !(bestSrml instanceof SubResourceLocator)) continue;
            bestSrml = srml;
            bestSrmlChars = srmlNoLitChars;
            bestSrmlNoCaptGroups = srmlNoCaptGroups;
            bestSrmlNoNonDefCaptGroups = srmlNoNonDefCaptGroups;
        }
        return (R)bestSrml;
    }

    public static void removeNotSupportedHttpMethod(Collection<ResourceMethod> resourceMethods, Method httpMethod, boolean alsoGet) {
        Iterator<ResourceMethod> methodIter = resourceMethods.iterator();
        while (methodIter.hasNext()) {
            ResourceMethod resourceMethod = methodIter.next();
            if (resourceMethod.isHttpMethodSupported(httpMethod, alsoGet)) continue;
            methodIter.remove();
        }
    }

    private static enum ConsOrProdMime {
        CONSUME_MIME,
        PRODUCE_MIME;

    }
}

