/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.wrappers.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Providers;
import org.restlet.engine.util.SystemUtils;
import org.restlet.ext.jaxrs.InstantiateException;
import org.restlet.ext.jaxrs.ObjectFactory;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedContext;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertCookieParamException;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertHeaderParamException;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertMatrixParamException;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertPathParamException;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertQueryParamException;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertRepresentationException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalBeanSetterTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalConstrParamTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalFieldTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathParamTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.ImplementationException;
import org.restlet.ext.jaxrs.internal.exceptions.InjectException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingAnnotationException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingConstructorException;
import org.restlet.ext.jaxrs.internal.exceptions.NoMessageBodyReaderException;
import org.restlet.ext.jaxrs.internal.exceptions.ProviderNotInitializableException;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.ext.jaxrs.internal.wrappers.WrapperUtil;
import org.restlet.ext.jaxrs.internal.wrappers.params.ParameterList;
import org.restlet.ext.jaxrs.internal.wrappers.provider.AbstractProviderWrapper;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ContextResolver;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ExtensionBackwardMapping;
import org.restlet.ext.jaxrs.internal.wrappers.provider.JaxRsProviders;
import org.restlet.ext.jaxrs.internal.wrappers.provider.MessageBodyReader;
import org.restlet.ext.jaxrs.internal.wrappers.provider.MessageBodyWriter;
import org.restlet.ext.jaxrs.internal.wrappers.provider.SingletonProvider;

@Deprecated
class PerRequestProviderWrapper
extends AbstractProviderWrapper {
    private final JaxRsProviders allProviders;
    private final ExtensionBackwardMapping extensionBackwardMapping;
    private final Class<?> jaxRsProviderClass;
    private final Logger logger;
    private final ObjectFactory objectFactory;
    private final ThreadLocalizedContext tlContext;

    public PerRequestProviderWrapper(Class<?> jaxRsProviderClass, ObjectFactory objectFactory, ThreadLocalizedContext tlContext, JaxRsProviders allProviders, ExtensionBackwardMapping extensionBackwardMapping, Logger logger) throws IllegalArgumentException, InvocationTargetException, MissingConstructorException, InstantiateException, MissingAnnotationException, WebApplicationException, IllegalConstrParamTypeException, IllegalPathParamTypeException {
        super(jaxRsProviderClass);
        this.jaxRsProviderClass = jaxRsProviderClass;
        this.objectFactory = objectFactory;
        this.tlContext = tlContext;
        this.allProviders = allProviders;
        this.extensionBackwardMapping = extensionBackwardMapping;
        this.logger = logger;
        this.createInstance();
    }

    private Object createInstance() throws IllegalArgumentException, InvocationTargetException, InstantiateException, MissingAnnotationException, WebApplicationException, IllegalConstrParamTypeException, IllegalPathParamTypeException, MissingConstructorException {
        ParameterList parameters;
        Object jaxRsProvider;
        Util.checkClassConcrete(this.jaxRsProviderClass, "provider");
        if (this.objectFactory != null && (jaxRsProvider = this.objectFactory.getInstance(this.jaxRsProviderClass)) != null) {
            return jaxRsProvider;
        }
        Constructor<?> providerConstructor = WrapperUtil.findJaxRsConstructor(this.jaxRsProviderClass, "provider");
        try {
            parameters = new ParameterList(providerConstructor, this.tlContext, false, this.allProviders, this.extensionBackwardMapping, false, this.logger, true);
        }
        catch (IllegalTypeException ite) {
            throw new IllegalConstrParamTypeException(ite);
        }
        try {
            Object[] args = parameters.get();
            return WrapperUtil.createInstance(providerConstructor, args);
        }
        catch (NoMessageBodyReaderException e) {
            throw new IllegalArgumentException("Could not instantiate the Provider, class " + this.jaxRsProviderClass.getName(), (Throwable)((Object)e));
        }
        catch (ConvertRepresentationException e) {
            throw new IllegalArgumentException("Could not instantiate the Provider, class " + this.jaxRsProviderClass.getName(), e);
        }
        catch (ConvertHeaderParamException e) {
            throw new IllegalArgumentException("Could not instantiate the Provider, class " + this.jaxRsProviderClass.getName(), (Throwable)((Object)e));
        }
        catch (ConvertPathParamException e) {
            throw new IllegalArgumentException("Could not instantiate the Provider, class " + this.jaxRsProviderClass.getName(), (Throwable)((Object)e));
        }
        catch (ConvertMatrixParamException e) {
            throw new IllegalArgumentException("Could not instantiate the Provider, class " + this.jaxRsProviderClass.getName(), (Throwable)((Object)e));
        }
        catch (ConvertQueryParamException e) {
            throw new IllegalArgumentException("Could not instantiate the Provider, class " + this.jaxRsProviderClass.getName(), (Throwable)((Object)e));
        }
        catch (ConvertCookieParamException e) {
            throw new IllegalArgumentException("Could not instantiate the Provider, class " + this.jaxRsProviderClass.getName(), (Throwable)((Object)e));
        }
    }

    @Override
    public final boolean equals(Object otherProvider) {
        if (this == otherProvider) {
            return true;
        }
        if (!(otherProvider instanceof PerRequestProviderWrapper)) {
            return false;
        }
        return this.jaxRsProviderClass.equals(((PerRequestProviderWrapper)otherProvider).jaxRsProviderClass);
    }

    @Override
    public String getClassName() {
        return this.jaxRsProviderClass.getName();
    }

    @Override
    public Class<?> getExcMapperType() {
        return Util.getGenericClass(this.jaxRsProviderClass, ExceptionMapper.class);
    }

    @Override
    public ContextResolver getInitializedCtxResolver() throws ProviderNotInitializableException {
        return new SingletonProvider(this.instantiateAndInitialize(), this.logger);
    }

    @Override
    public ExceptionMapper<? extends Throwable> getInitializedExcMapper() throws ProviderNotInitializableException {
        return (ExceptionMapper)this.instantiateAndInitialize();
    }

    @Override
    public MessageBodyReader getInitializedReader() throws ProviderNotInitializableException {
        return new SingletonProvider(this.instantiateAndInitialize(), this.logger);
    }

    @Override
    public MessageBodyWriter getInitializedWriter() throws ProviderNotInitializableException {
        return new SingletonProvider(this.instantiateAndInitialize(), this.logger);
    }

    @Override
    public int hashCode() {
        return SystemUtils.hashCode((Object[])new Object[]{this.jaxRsProviderClass});
    }

    @Override
    public void initAtAppStartUp(ThreadLocalizedContext tlContext, Providers allProviders, ExtensionBackwardMapping extensionBackwardMapping) throws InjectException, InvocationTargetException, IllegalTypeException {
    }

    private Object instantiateAndInitialize() throws ProviderNotInitializableException {
        Object jaxRsProvider;
        try {
            jaxRsProvider = this.createInstance();
        }
        catch (IllegalConstrParamTypeException e) {
            throw new ImplementationException("The provider could not be instantiated, but this could not be here", e);
        }
        catch (IllegalPathParamTypeException e) {
            throw new ImplementationException("The provider could not be instantiated, but this could not be here", e);
        }
        catch (IllegalArgumentException e) {
            throw new ImplementationException("The provider could not be instantiated, but this could not be here", e);
        }
        catch (WebApplicationException e) {
            throw new ImplementationException("The provider could not be instantiated, but this could not be here", e);
        }
        catch (MissingAnnotationException e) {
            throw new ImplementationException("The provider could not be instantiated, but this could not be here", e);
        }
        catch (MissingConstructorException e) {
            throw new ImplementationException("The provider could not be instantiated, but this could not be here", e);
        }
        catch (InvocationTargetException e) {
            throw new ImplementationException("The provider could not be instantiated, but this could not be here", e);
        }
        catch (InstantiateException e) {
            throw new ImplementationException("The provider could not be instantiated, but this could not be here", e);
        }
        try {
            this.initProvider(jaxRsProvider, this.tlContext, this.allProviders, this.extensionBackwardMapping);
        }
        catch (IllegalFieldTypeException e) {
            this.logger.log(Level.WARNING, "The provider " + this.getClassName() + " could not be initialized and so it could not be used", e);
            throw new ProviderNotInitializableException();
        }
        catch (IllegalBeanSetterTypeException e) {
            this.logger.log(Level.WARNING, "The provider " + this.getClassName() + " could not be initialized and so it could not be used", e);
            throw new ProviderNotInitializableException();
        }
        catch (InjectException e) {
            this.logger.log(Level.WARNING, "The provider " + this.getClassName() + " could not be initialized and so it could not be used", e);
            throw new ProviderNotInitializableException();
        }
        catch (InvocationTargetException e) {
            this.logger.log(Level.WARNING, "The provider " + this.getClassName() + " could not be initialized and so it could not be used", e);
            throw new ProviderNotInitializableException();
        }
        return jaxRsProvider;
    }

    @Override
    public boolean isContextResolver() {
        return Util.doesImplement(this.jaxRsProviderClass, javax.ws.rs.ext.ContextResolver.class);
    }

    @Override
    public boolean isExceptionMapper() {
        return Util.doesImplement(this.jaxRsProviderClass, ExceptionMapper.class);
    }

    @Override
    public boolean isReader() {
        return Util.doesImplement(this.jaxRsProviderClass, javax.ws.rs.ext.MessageBodyReader.class);
    }

    @Override
    public boolean isWriter() {
        return Util.doesImplement(this.jaxRsProviderClass, javax.ws.rs.ext.MessageBodyWriter.class);
    }
}

