/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.engine.application.MetadataExtension;
import org.restlet.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataService
extends Service {
    private volatile CharacterSet defaultCharacterSet = CharacterSet.DEFAULT;
    private volatile Encoding defaultEncoding = Encoding.IDENTITY;
    private volatile Language defaultLanguage = Language.DEFAULT;
    private volatile MediaType defaultMediaType = MediaType.APPLICATION_OCTET_STREAM;
    private final List<MetadataExtension> mappings = new CopyOnWriteArrayList<MetadataExtension>();

    public MetadataService() {
        this.addCommonExtensions();
    }

    public void addCommonExtensions() {
        ArrayList<MetadataExtension> dm = new ArrayList<MetadataExtension>();
        this.ext(dm, "en", Language.ENGLISH);
        this.ext(dm, "es", Language.SPANISH);
        this.ext(dm, "fr", Language.FRENCH);
        this.ext(dm, "ascii", CharacterSet.US_ASCII);
        this.ext(dm, "ai", MediaType.APPLICATION_POSTSCRIPT);
        this.ext(dm, "atom", MediaType.APPLICATION_ATOM);
        this.ext(dm, "atomcat", MediaType.APPLICATION_ATOMPUB_CATEGORY);
        this.ext(dm, "atomsvc", MediaType.APPLICATION_ATOMPUB_SERVICE);
        this.ext(dm, "au", MediaType.AUDIO_BASIC);
        this.ext(dm, "bin", MediaType.APPLICATION_OCTET_STREAM);
        this.ext(dm, "bmp", MediaType.IMAGE_BMP);
        this.ext(dm, "class", MediaType.APPLICATION_JAVA);
        this.ext(dm, "css", MediaType.TEXT_CSS);
        this.ext(dm, "csv", MediaType.TEXT_CSV);
        this.ext(dm, "dat", MediaType.TEXT_DAT);
        this.ext(dm, "dib", MediaType.IMAGE_BMP);
        this.ext(dm, "doc", MediaType.APPLICATION_WORD);
        this.ext(dm, "docm", MediaType.APPLICATION_MSOFFICE_DOCM);
        this.ext(dm, "docx", MediaType.APPLICATION_MSOFFICE_DOCX);
        this.ext(dm, "dotm", MediaType.APPLICATION_MSOFFICE_DOTM);
        this.ext(dm, "dotx", MediaType.APPLICATION_MSOFFICE_DOTX);
        this.ext(dm, "dtd", MediaType.APPLICATION_XML_DTD);
        this.ext(dm, "ecore", MediaType.APPLICATION_ECORE);
        this.ext(dm, "eps", MediaType.APPLICATION_POSTSCRIPT);
        this.ext(dm, "exe", MediaType.APPLICATION_OCTET_STREAM);
        this.ext(dm, "fmt", Encoding.FREEMARKER);
        this.ext(dm, "form", MediaType.APPLICATION_WWW_FORM);
        this.ext(dm, "ftl", Encoding.FREEMARKER, true);
        this.ext(dm, "gif", MediaType.IMAGE_GIF);
        this.ext(dm, "gwt", MediaType.APPLICATION_JAVA_OBJECT_GWT);
        this.ext(dm, "hqx", MediaType.APPLICATION_MAC_BINHEX40);
        this.ext(dm, "ico", MediaType.IMAGE_ICON);
        this.ext(dm, "jad", MediaType.TEXT_J2ME_APP_DESCRIPTOR);
        this.ext(dm, "jar", MediaType.APPLICATION_JAVA_ARCHIVE);
        this.ext(dm, "java", MediaType.TEXT_PLAIN);
        this.ext(dm, "jnlp", MediaType.APPLICATION_JNLP);
        this.ext(dm, "jpe", MediaType.IMAGE_JPEG);
        this.ext(dm, "jpeg", MediaType.IMAGE_JPEG);
        this.ext(dm, "jpg", MediaType.IMAGE_JPEG);
        this.ext(dm, "js", MediaType.APPLICATION_JAVASCRIPT);
        this.ext(dm, "jsf", MediaType.TEXT_PLAIN);
        this.ext(dm, "kar", MediaType.AUDIO_MIDI);
        this.ext(dm, "latex", MediaType.APPLICATION_LATEX);
        this.ext(dm, "latin1", CharacterSet.ISO_8859_1);
        this.ext(dm, "mac", CharacterSet.MACINTOSH);
        this.ext(dm, "man", MediaType.APPLICATION_TROFF_MAN);
        this.ext(dm, "mathml", MediaType.APPLICATION_MATHML);
        this.ext(dm, "mid", MediaType.AUDIO_MIDI);
        this.ext(dm, "midi", MediaType.AUDIO_MIDI);
        this.ext(dm, "mov", MediaType.VIDEO_QUICKTIME);
        this.ext(dm, "mp2", MediaType.AUDIO_MPEG);
        this.ext(dm, "mp3", MediaType.AUDIO_MPEG);
        this.ext(dm, "mp4", MediaType.VIDEO_MP4);
        this.ext(dm, "mpe", MediaType.VIDEO_MPEG);
        this.ext(dm, "mpeg", MediaType.VIDEO_MPEG);
        this.ext(dm, "mpg", MediaType.VIDEO_MPEG);
        this.ext(dm, "n3", MediaType.TEXT_RDF_N3);
        this.ext(dm, "nt", MediaType.TEXT_PLAIN);
        this.ext(dm, "odb", MediaType.APPLICATION_OPENOFFICE_ODB);
        this.ext(dm, "odc", MediaType.APPLICATION_OPENOFFICE_ODC);
        this.ext(dm, "odf", MediaType.APPLICATION_OPENOFFICE_ODF);
        this.ext(dm, "odi", MediaType.APPLICATION_OPENOFFICE_ODI);
        this.ext(dm, "odm", MediaType.APPLICATION_OPENOFFICE_ODM);
        this.ext(dm, "odg", MediaType.APPLICATION_OPENOFFICE_ODG);
        this.ext(dm, "odp", MediaType.APPLICATION_OPENOFFICE_ODP);
        this.ext(dm, "ods", MediaType.APPLICATION_OPENOFFICE_ODS);
        this.ext(dm, "odt", MediaType.APPLICATION_OPENOFFICE_ODT);
        this.ext(dm, "onetoc", MediaType.APPLICATION_MSOFFICE_ONETOC);
        this.ext(dm, "onetoc2", MediaType.APPLICATION_MSOFFICE_ONETOC2);
        this.ext(dm, "otg", MediaType.APPLICATION_OPENOFFICE_OTG);
        this.ext(dm, "oth", MediaType.APPLICATION_OPENOFFICE_OTH);
        this.ext(dm, "otp", MediaType.APPLICATION_OPENOFFICE_OTP);
        this.ext(dm, "ots", MediaType.APPLICATION_OPENOFFICE_OTS);
        this.ext(dm, "ott", MediaType.APPLICATION_OPENOFFICE_OTT);
        this.ext(dm, "oxt", MediaType.APPLICATION_OPENOFFICE_OXT);
        this.ext(dm, "pdf", MediaType.APPLICATION_PDF);
        this.ext(dm, "png", MediaType.IMAGE_PNG);
        this.ext(dm, "potx", MediaType.APPLICATION_MSOFFICE_POTX);
        this.ext(dm, "potm", MediaType.APPLICATION_MSOFFICE_POTM);
        this.ext(dm, "ppam", MediaType.APPLICATION_MSOFFICE_PPAM);
        this.ext(dm, "pps", MediaType.APPLICATION_POWERPOINT);
        this.ext(dm, "ppsm", MediaType.APPLICATION_MSOFFICE_PPSM);
        this.ext(dm, "ppsx", MediaType.APPLICATION_MSOFFICE_PPSX);
        this.ext(dm, "ppt", MediaType.APPLICATION_POWERPOINT);
        this.ext(dm, "pptm", MediaType.APPLICATION_MSOFFICE_PPTM);
        this.ext(dm, "pptx", MediaType.APPLICATION_MSOFFICE_PPTX);
        this.ext(dm, "ps", MediaType.APPLICATION_POSTSCRIPT);
        this.ext(dm, "qt", MediaType.VIDEO_QUICKTIME);
        this.ext(dm, "rdf", MediaType.APPLICATION_RDF_XML);
        this.ext(dm, "rnc", MediaType.APPLICATION_RELAXNG_COMPACT);
        this.ext(dm, "rng", MediaType.APPLICATION_RELAXNG_XML);
        this.ext(dm, "rss", MediaType.APPLICATION_RSS);
        this.ext(dm, "rtf", MediaType.APPLICATION_RTF);
        this.ext(dm, "sav", MediaType.APPLICATION_SPSS_SAV);
        this.ext(dm, "sit", MediaType.APPLICATION_STUFFIT);
        this.ext(dm, "sldm", MediaType.APPLICATION_MSOFFICE_SLDM);
        this.ext(dm, "sldx", MediaType.APPLICATION_MSOFFICE_SLDX);
        this.ext(dm, "snd", MediaType.AUDIO_BASIC);
        this.ext(dm, "sps", MediaType.APPLICATION_SPSS_SPS);
        this.ext(dm, "sta", MediaType.APPLICATION_STATA_STA);
        this.ext(dm, "svg", MediaType.IMAGE_SVG);
        this.ext(dm, "swf", MediaType.APPLICATION_FLASH);
        this.ext(dm, "tar", MediaType.APPLICATION_TAR);
        this.ext(dm, "tex", MediaType.APPLICATION_TEX);
        this.ext(dm, "tif", MediaType.IMAGE_TIFF);
        this.ext(dm, "tiff", MediaType.IMAGE_TIFF);
        this.ext(dm, "tsv", MediaType.TEXT_TSV);
        this.ext(dm, "ulw", MediaType.AUDIO_BASIC);
        this.ext(dm, "utf16", CharacterSet.UTF_16);
        this.ext(dm, "utf8", CharacterSet.UTF_8);
        this.ext(dm, "vm", Encoding.VELOCITY);
        this.ext(dm, "vrml", MediaType.MODEL_VRML);
        this.ext(dm, "vxml", MediaType.APPLICATION_VOICEXML);
        this.ext(dm, "wadl", MediaType.APPLICATION_WADL);
        this.ext(dm, "wav", MediaType.AUDIO_WAV);
        this.ext(dm, "win", CharacterSet.WINDOWS_1252);
        this.ext(dm, "wrl", MediaType.MODEL_VRML);
        this.ext(dm, "xht", MediaType.APPLICATION_XHTML);
        this.ext(dm, "xls", MediaType.APPLICATION_EXCEL);
        this.ext(dm, "xlsx", MediaType.APPLICATION_MSOFFICE_XLSX);
        this.ext(dm, "xlsm", MediaType.APPLICATION_MSOFFICE_XLSM);
        this.ext(dm, "xltx", MediaType.APPLICATION_MSOFFICE_XLTX);
        this.ext(dm, "xltm", MediaType.APPLICATION_MSOFFICE_XLTM);
        this.ext(dm, "xlsb", MediaType.APPLICATION_MSOFFICE_XLSB);
        this.ext(dm, "xlam", MediaType.APPLICATION_MSOFFICE_XLAM);
        this.ext(dm, "xmi", MediaType.APPLICATION_XMI);
        this.ext(dm, "xsd", MediaType.APPLICATION_W3C_SCHEMA);
        this.ext(dm, "xsl", MediaType.APPLICATION_W3C_XSLT);
        this.ext(dm, "xslt", MediaType.APPLICATION_W3C_XSLT);
        this.ext(dm, "xul", MediaType.APPLICATION_XUL);
        this.ext(dm, "z", MediaType.APPLICATION_COMPRESS);
        this.ext(dm, "zip", MediaType.APPLICATION_ZIP);
        this.ext(dm, "htm", MediaType.TEXT_HTML);
        this.ext(dm, "html", MediaType.TEXT_HTML);
        this.ext(dm, "json", MediaType.APPLICATION_JSON);
        this.ext(dm, "txt", MediaType.TEXT_PLAIN, true);
        this.ext(dm, "xhtml", MediaType.APPLICATION_XHTML);
        this.ext(dm, "xml", MediaType.TEXT_XML);
        this.ext(dm, "xml", MediaType.APPLICATION_XML);
        this.mappings.addAll(dm);
    }

    public void addExtension(String extension, Metadata metadata) {
        this.addExtension(extension, metadata, false);
    }

    public void addExtension(String extension, Metadata metadata, boolean preferred) {
        if (preferred) {
            this.mappings.add(0, new MetadataExtension(extension, metadata));
        } else {
            this.mappings.add(new MetadataExtension(extension, metadata));
        }
    }

    public void clearExtensions() {
        this.mappings.clear();
    }

    private void ext(List<MetadataExtension> extensions, String extension, Metadata metadata) {
        this.ext(extensions, extension, metadata, false);
    }

    private void ext(List<MetadataExtension> extensions, String extension, Metadata metadata, boolean preferred) {
        if (preferred) {
            extensions.add(0, new MetadataExtension(extension, metadata));
        } else {
            extensions.add(new MetadataExtension(extension, metadata));
        }
    }

    public List<CharacterSet> getAllCharacterSets(String extension) {
        ArrayList<CharacterSet> result = null;
        if (extension != null) {
            for (MetadataExtension metadataExtension : this.mappings) {
                if (!extension.equals(metadataExtension.getName()) || !(metadataExtension.getMetadata() instanceof CharacterSet)) continue;
                if (result == null) {
                    result = new ArrayList<CharacterSet>();
                }
                result.add(metadataExtension.getCharacterSet());
            }
        }
        return result;
    }

    public List<Language> getAllLanguages(String extension) {
        ArrayList<Language> result = null;
        if (extension != null) {
            for (MetadataExtension metadataExtension : this.mappings) {
                if (!extension.equals(metadataExtension.getName()) || !(metadataExtension.getMetadata() instanceof Language)) continue;
                if (result == null) {
                    result = new ArrayList<Language>();
                }
                result.add(metadataExtension.getLanguage());
            }
        }
        return result;
    }

    public List<MediaType> getAllMediaTypes(String extension) {
        ArrayList<MediaType> result = null;
        if (extension != null) {
            for (MetadataExtension metadataExtension : this.mappings) {
                if (!extension.equals(metadataExtension.getName()) || !(metadataExtension.getMetadata() instanceof MediaType)) continue;
                if (result == null) {
                    result = new ArrayList<MediaType>();
                }
                result.add(metadataExtension.getMediaType());
            }
        }
        return result;
    }

    public List<Metadata> getAllMetadata(String extension) {
        ArrayList<Metadata> result = null;
        if (extension != null) {
            for (MetadataExtension metadataExtension : this.mappings) {
                if (!extension.equals(metadataExtension.getName())) continue;
                if (result == null) {
                    result = new ArrayList<Metadata>();
                }
                result.add(metadataExtension.getMetadata());
            }
        }
        return result;
    }

    public CharacterSet getCharacterSet(String extension) {
        return this.getMetadata(extension, CharacterSet.class);
    }

    public CharacterSet getDefaultCharacterSet() {
        return this.defaultCharacterSet;
    }

    public Encoding getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public MediaType getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public Encoding getEncoding(String extension) {
        return this.getMetadata(extension, Encoding.class);
    }

    public String getExtension(Metadata metadata) {
        if (metadata != null) {
            for (MetadataExtension metadataExtension : this.mappings) {
                if (!metadata.equals(metadataExtension.getMetadata())) continue;
                return metadataExtension.getName();
            }
        }
        return null;
    }

    public Language getLanguage(String extension) {
        return this.getMetadata(extension, Language.class);
    }

    public MediaType getMediaType(String extension) {
        return this.getMetadata(extension, MediaType.class);
    }

    public Metadata getMetadata(String extension) {
        if (extension != null) {
            for (MetadataExtension metadataExtension : this.mappings) {
                if (!extension.equals(metadataExtension.getName())) continue;
                return metadataExtension.getMetadata();
            }
        }
        return null;
    }

    public <T extends Metadata> T getMetadata(String extension, Class<T> metadataType) {
        Metadata metadata = this.getMetadata(extension);
        if (metadata != null && metadataType.isAssignableFrom(metadata.getClass())) {
            return (T)((Metadata)metadataType.cast(metadata));
        }
        return null;
    }

    public void setDefaultCharacterSet(CharacterSet defaultCharacterSet) {
        this.defaultCharacterSet = defaultCharacterSet;
    }

    public void setDefaultEncoding(Encoding defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setDefaultLanguage(Language defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public void setDefaultMediaType(MediaType defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }
}

