/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.server.priming.batch;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.scassandra.server.priming.BatchExecution;
import org.scassandra.server.priming.BatchQuery;
import org.scassandra.server.priming.batch.BatchCriteria;
import org.scassandra.server.priming.batch.BatchPrimeSingle;
import org.scassandra.server.priming.batch.BatchQueryPrime;
import org.scassandra.server.priming.query.Prime;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u001b\ty\u0001K]5nK\n\u000bGo\u00195Ti>\u0014XM\u0003\u0002\u0004\t\u0005)!-\u0019;dQ*\u0011QAB\u0001\baJLW.\u001b8h\u0015\t9\u0001\"\u0001\u0004tKJ4XM\u001d\u0006\u0003\u0013)\t!b]2bgN\fg\u000e\u001a:b\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\u000f\u000e\u0003YQ!a\u0006\r\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005eQ\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003m\t1aY8n\u0013\tibCA\u0006MCjLHj\\4hS:<\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\bF\u0001\"!\t\u0011\u0003!D\u0001\u0003\u0011\u001d!\u0003\u00011A\u0005\u0002\u0015\na\u0001\u001d:j[\u0016\u001cX#\u0001\u0014\u0011\t\u001dRS\u0006\r\b\u0003\u001f!J!!\u000b\t\u0002\rA\u0013X\rZ3g\u0013\tYCFA\u0002NCBT!!\u000b\t\u0011\u0005\tr\u0013BA\u0018\u0003\u00055\u0011\u0015\r^2i\u0007JLG/\u001a:jCB\u0011!%M\u0005\u0003e\t\u0011\u0001CQ1uG\"\u0004&/[7f'&tw\r\\3\t\u000fQ\u0002\u0001\u0019!C\u0001k\u0005Q\u0001O]5nKN|F%Z9\u0015\u0005YJ\u0004CA\b8\u0013\tA\u0004C\u0001\u0003V]&$\bb\u0002\u001e4\u0003\u0003\u0005\rAJ\u0001\u0004q\u0012\n\u0004B\u0002\u001f\u0001A\u0003&a%A\u0004qe&lWm\u001d\u0011\t\u000by\u0002A\u0011A \u0002\rI,7m\u001c:e)\t1\u0004\tC\u0003B{\u0001\u0007\u0001'A\u0003qe&lW\rC\u0003D\u0001\u0011\u0005A)A\u0003baBd\u0017\u0010\u0006\u0002F\u001dB\u0019qB\u0012%\n\u0005\u001d\u0003\"AB(qi&|g\u000e\u0005\u0002J\u00196\t!J\u0003\u0002L\t\u0005)\u0011/^3ss&\u0011QJ\u0013\u0002\u0006!JLW.\u001a\u0005\u0006\u001f\n\u0003\r\u0001U\u0001\u000baJLW.Z'bi\u000eD\u0007CA)S\u001b\u0005!\u0011BA*\u0005\u00059\u0011\u0015\r^2i\u000bb,7-\u001e;j_:DQ!\u0016\u0001\u0005\u0002Y\u000bQa\u00197fCJ$\u0012A\u000e")
public class PrimeBatchStore
implements LazyLogging {
    private Map<BatchCriteria, BatchPrimeSingle> primes;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        PrimeBatchStore primeBatchStore = this;
        synchronized (primeBatchStore) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Map<BatchCriteria, BatchPrimeSingle> primes() {
        return this.primes;
    }

    public void primes_$eq(Map<BatchCriteria, BatchPrimeSingle> x$1) {
        this.primes = x$1;
    }

    public void record(BatchPrimeSingle prime) {
        BatchPrimeSingle p = prime.withDefaults();
        BatchCriteria criteria = new BatchCriteria((Seq<BatchQueryPrime>)p.when().queries(), (List<Enumeration.Value>)((List)p.when().consistency().get()), (Enumeration.Value)p.when().batchType().get());
        this.primes_$eq((Map<BatchCriteria, BatchPrimeSingle>)this.primes().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)criteria), (Object)p)));
    }

    public Option<Prime> apply(BatchExecution primeMatch) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Batch Prime Match {} current primes {}", (Object[])List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{primeMatch, this.primes()})).toArray(ClassTag$.MODULE$.apply(Object.class)));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.primes().find((Function1)new Serializable(this, primeMatch){
            public static final long serialVersionUID = 0L;
            private final BatchExecution primeMatch$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Tuple2<BatchCriteria, BatchPrimeSingle> x0$1) {
                Tuple2<BatchCriteria, BatchPrimeSingle> tuple2 = x0$1;
                if (tuple2 == null) throw new MatchError(tuple2);
                BatchCriteria batchCriteria = (BatchCriteria)tuple2._1();
                Seq<BatchQueryPrime> seq = batchCriteria.queries();
                Object object = this.primeMatch$1.batchQueries().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BatchQueryPrime apply(BatchQuery bq) {
                        return new BatchQueryPrime(bq.query(), bq.batchQueryKind());
                    }
                }, Seq$.MODULE$.canBuildFrom());
                if (seq == null) {
                    if (object != null) {
                        return false;
                    }
                } else if (!seq.equals(object)) return false;
                if (!batchCriteria.consistency().contains((Object)this.primeMatch$1.consistency())) return false;
                Enumeration.Value value = batchCriteria.batchType();
                Enumeration.Value value2 = this.primeMatch$1.batchType();
                if (value == null) {
                    if (value2 == null) return true;
                    return false;
                } else {
                    if (!value.equals(value2)) return false;
                    return true;
                }
            }
            {
                this.primeMatch$1 = primeMatch$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Product apply(Tuple2<BatchCriteria, BatchPrimeSingle> x$1) {
                return ((BatchPrimeSingle)x$1._2()).prime();
            }
        });
    }

    public void clear() {
        this.primes_$eq((Map<BatchCriteria, BatchPrimeSingle>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
    }

    public PrimeBatchStore() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.primes = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }
}

