/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.server.priming.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.regex.Matcher;
import org.scassandra.codec.Message;
import org.scassandra.codec.Query;
import org.scassandra.codec.SetKeyspace;
import org.scassandra.server.priming.BadCriteria;
import org.scassandra.server.priming.PrimeAddResult;
import org.scassandra.server.priming.PrimeAddSuccess$;
import org.scassandra.server.priming.PrimeValidator;
import org.scassandra.server.priming.query.Prime;
import org.scassandra.server.priming.query.PrimeCriteria;
import org.scassandra.server.priming.query.PrimeQuerySingle;
import org.scassandra.server.priming.query.PrimeQueryStore$;
import org.scassandra.server.priming.query.Reply;
import org.scassandra.server.priming.query.Reply$;
import org.scassandra.server.priming.routes.PrimingJsonHelper$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0001\u0003\u00015\u0011q\u0002\u0015:j[\u0016\fV/\u001a:z'R|'/\u001a\u0006\u0003\u0007\u0011\tQ!];fefT!!\u0002\u0004\u0002\u000fA\u0014\u0018.\\5oO*\u0011q\u0001C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005%Q\u0011AC:dCN\u001c\u0018M\u001c3sC*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u001d\u001b\u00051\"BA\f\u0019\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tI\"$\u0001\u0005usB,7/\u00194f\u0015\u0005Y\u0012aA2p[&\u0011QD\u0006\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\rC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002\u0005!9A\u0005\u0001b\u0001\n\u0003)\u0013!\u0003<bY&$\u0017\r^8s+\u00051\u0003CA\u0014)\u001b\u0005!\u0011BA\u0015\u0005\u00059\u0001&/[7f-\u0006d\u0017\u000eZ1u_JDaa\u000b\u0001!\u0002\u00131\u0013A\u0003<bY&$\u0017\r^8sA!9Q\u0006\u0001a\u0001\n\u0003q\u0013aC9vKJL\bK]5nKN,\u0012a\f\t\u0005aU:$(D\u00012\u0015\t\u00114'A\u0005j[6,H/\u00192mK*\u0011A\u0007E\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001c2\u0005\ri\u0015\r\u001d\t\u0003EaJ!!\u000f\u0002\u0003\u001bA\u0013\u0018.\\3De&$XM]5b!\t\u00113(\u0003\u0002=\u0005\t\u0001\u0002K]5nKF+XM]=TS:<G.\u001a\u0005\b}\u0001\u0001\r\u0011\"\u0001@\u0003=\tX/\u001a:z!JLW.Z:`I\u0015\fHC\u0001!D!\ty\u0011)\u0003\u0002C!\t!QK\\5u\u0011\u001d!U(!AA\u0002=\n1\u0001\u001f\u00132\u0011\u00191\u0005\u0001)Q\u0005_\u0005a\u0011/^3ssB\u0013\u0018.\\3tA!9\u0001\n\u0001a\u0001\n\u0003q\u0013AE9vKJL\b+\u0019;uKJt\u0007K]5nKNDqA\u0013\u0001A\u0002\u0013\u00051*\u0001\frk\u0016\u0014\u0018\u0010U1ui\u0016\u0014h\u000e\u0015:j[\u0016\u001cx\fJ3r)\t\u0001E\nC\u0004E\u0013\u0006\u0005\t\u0019A\u0018\t\r9\u0003\u0001\u0015)\u00030\u0003M\tX/\u001a:z!\u0006$H/\u001a:o!JLW.Z:!\u0011\u0015\u0001\u0006\u0001\"\u0001R\u000319W\r^!mYB\u0013\u0018.\\3t+\u0005\u0011\u0006cA*\\u9\u0011A+\u0017\b\u0003+bk\u0011A\u0016\u0006\u0003/2\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005i\u0003\u0012a\u00029bG.\fw-Z\u0005\u00039v\u0013A\u0001T5ti*\u0011!\f\u0005\u0005\u0006?\u0002!\t\u0001Y\u0001\u0004C\u0012$GCA1e!\t9#-\u0003\u0002d\t\tq\u0001K]5nK\u0006#GMU3tk2$\b\"B3_\u0001\u0004Q\u0014\u0001\u00059sS6,\u0017+^3ssNKgn\u001a7f\u0011\u00159\u0007\u0001\"\u0001i\u0003\u0015\u0019G.Z1s)\u0005\u0001\u0005\"\u00026\u0001\t\u0003Y\u0017!B1qa2LHC\u00017s!\ryQn\\\u0005\u0003]B\u0011aa\u00149uS>t\u0007C\u0001\u0012q\u0013\t\t(AA\u0003Qe&lW\rC\u0003\u0004S\u0002\u00071\u000f\u0005\u0002uo6\tQO\u0003\u0002w\u0011\u0005)1m\u001c3fG&\u0011\u00010\u001e\u0002\u0006#V,'/_\u0004\u0006u\nA\ta_\u0001\u0010!JLW.Z)vKJL8\u000b^8sKB\u0011!\u0005 \u0004\u0006\u0003\tA\t!`\n\u0003y:AQa\b?\u0005\u0002}$\u0012a\u001f\u0005\u000b\u0003\u0007a(\u0019!C\u0001y\u0006\u0015\u0011aC;tK.+\u0017p\u001d9bG\u0016,\"!a\u0002\u0011\t\u0005%\u0011qC\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005)!/Z4fq*!\u0011\u0011CA\n\u0003\u0011)H/\u001b7\u000b\u0005\u0005U\u0011\u0001\u00026bm\u0006LA!!\u0007\u0002\f\t9\u0001+\u0019;uKJt\u0007\u0002CA\u000fy\u0002\u0006I!a\u0002\u0002\u0019U\u001cXmS3zgB\f7-\u001a\u0011")
public class PrimeQueryStore
implements LazyLogging {
    private final PrimeValidator validator;
    private Map<PrimeCriteria, PrimeQuerySingle> queryPrimes;
    private Map<PrimeCriteria, PrimeQuerySingle> queryPatternPrimes;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        PrimeQueryStore primeQueryStore = this;
        synchronized (primeQueryStore) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public PrimeValidator validator() {
        return this.validator;
    }

    public Map<PrimeCriteria, PrimeQuerySingle> queryPrimes() {
        return this.queryPrimes;
    }

    public void queryPrimes_$eq(Map<PrimeCriteria, PrimeQuerySingle> x$1) {
        this.queryPrimes = x$1;
    }

    public Map<PrimeCriteria, PrimeQuerySingle> queryPatternPrimes() {
        return this.queryPatternPrimes;
    }

    public void queryPatternPrimes_$eq(Map<PrimeCriteria, PrimeQuerySingle> x$1) {
        this.queryPatternPrimes = x$1;
    }

    public List<PrimeQuerySingle> getAllPrimes() {
        return (List)this.queryPrimes().values().toList().$plus$plus((GenTraversableOnce)this.queryPatternPrimes().values().toList(), List$.MODULE$.canBuildFrom());
    }

    public PrimeAddResult add(PrimeQuerySingle primeQuerySingle) {
        Try<PrimeCriteria> try_;
        block12: {
            PrimeAddResult primeAddResult;
            block11: {
                BoxedUnit boxedUnit;
                block7: {
                    PrimeAddResult primeAddResult2;
                    block10: {
                        PrimeAddResult primeAddResult3;
                        block9: {
                            PrimeAddResult primeAddResult4;
                            block8: {
                                PrimeAddSuccess$ primeAddSuccess$;
                                PrimeQuerySingle p = primeQuerySingle.withDefaults();
                                try_ = PrimingJsonHelper$.MODULE$.extractPrimeCriteria(p);
                                if (!(try_ instanceof Success)) break block7;
                                Success success = (Success)try_;
                                PrimeCriteria criteria = (PrimeCriteria)success.value();
                                primeAddResult2 = this.validator().validate(criteria, (Prime)p.prime(), (List<PrimeCriteria>)this.queryPrimes().keys().toList());
                                if (!PrimeAddSuccess$.MODULE$.equals(primeAddResult2)) break block8;
                                if (criteria.patternMatch()) {
                                    this.queryPatternPrimes_$eq((Map<PrimeCriteria, PrimeQuerySingle>)this.queryPatternPrimes().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)criteria), (Object)p)));
                                    primeAddSuccess$ = PrimeAddSuccess$.MODULE$;
                                } else {
                                    this.queryPrimes_$eq((Map<PrimeCriteria, PrimeQuerySingle>)this.queryPrimes().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)criteria), (Object)p)));
                                    primeAddSuccess$ = PrimeAddSuccess$.MODULE$;
                                }
                                primeAddResult3 = primeAddSuccess$;
                                break block9;
                            }
                            if (primeAddResult2 == null) break block10;
                            primeAddResult3 = primeAddResult4 = primeAddResult2;
                        }
                        primeAddResult = primeAddResult3;
                        break block11;
                    }
                    throw new MatchError((Object)primeAddResult2);
                }
                if (!(try_ instanceof Failure)) break block12;
                Failure failure = (Failure)try_;
                Throwable x = failure.exception();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received invalid prime ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{failure})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                primeAddResult = new BadCriteria(x.getMessage());
            }
            return primeAddResult;
        }
        throw new MatchError(try_);
    }

    public void clear() {
        this.queryPrimes_$eq((Map<PrimeCriteria, PrimeQuerySingle>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.queryPatternPrimes_$eq((Map<PrimeCriteria, PrimeQuerySingle>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public Option<Prime> apply(Query query) {
        Some some;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)"Current primes: ").append(this.queryPrimes()).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Query for |", "|"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Matcher matcher = PrimeQueryStore$.MODULE$.useKeyspace().matcher(query.query());
        if (matcher.matches()) {
            BoxedUnit boxedUnit3;
            String keyspaceName = matcher.group(1);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Use keyspace ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyspaceName})));
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            some = new Some((Object)new Reply((Message)new SetKeyspace(keyspaceName), Reply$.MODULE$.apply$default$2(), Reply$.MODULE$.apply$default$3()));
        } else {
            some = this.queryPrimes().find(this.findPrime$1(query)).orElse((Function0)new Serializable(this, query){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PrimeQueryStore $outer;
                private final Query query$1;

                public final Option<Tuple2<PrimeCriteria, PrimeQuerySingle>> apply() {
                    return this.$outer.queryPatternPrimes().find(this.$outer.org$scassandra$server$priming$query$PrimeQueryStore$$findPrimePattern$1(this.query$1));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.query$1 = query$1;
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Product apply(Tuple2<PrimeCriteria, PrimeQuerySingle> x$1) {
                    return ((PrimeQuerySingle)x$1._2()).prime();
                }
            });
        }
        return some;
    }

    private final Function1 findPrime$1(Query query$1) {
        return new Serializable(this, query$1){
            public static final long serialVersionUID = 0L;
            private final Query query$1;

            public final boolean apply(Tuple2<PrimeCriteria, PrimeQuerySingle> entry) {
                String string = ((PrimeCriteria)entry._1()).query();
                String string2 = this.query$1.query();
                return !(string != null ? !string.equals(string2) : string2 != null) && ((PrimeCriteria)entry._1()).consistency().contains((Object)this.query$1.parameters().consistency());
            }
            {
                this.query$1 = query$1;
            }
        };
    }

    public final Function1 org$scassandra$server$priming$query$PrimeQueryStore$$findPrimePattern$1(Query query$1) {
        return new Serializable(this, query$1){
            public static final long serialVersionUID = 0L;
            private final Query query$1;

            public final boolean apply(Tuple2<PrimeCriteria, PrimeQuerySingle> entry) {
                Option option;
                block4: {
                    boolean bl;
                    block3: {
                        block2: {
                            option = new StringOps(Predef$.MODULE$.augmentString(((PrimeCriteria)entry._1()).query())).r().findFirstIn((CharSequence)this.query$1.query());
                            if (!(option instanceof Some)) break block2;
                            bl = ((PrimeCriteria)entry._1()).consistency().contains((Object)this.query$1.parameters().consistency());
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        bl = false;
                    }
                    return bl;
                }
                throw new MatchError((Object)option);
            }
            {
                this.query$1 = query$1;
            }
        };
    }

    public PrimeQueryStore() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.validator = new PrimeValidator();
        this.queryPrimes = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.queryPatternPrimes = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

