/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chromium.ChromiumDriverInfo;

@AutoService(value={WebDriverInfo.class})
public class ChromeDriverInfo
extends ChromiumDriverInfo {
    public String getDisplayName() {
        return "Chrome";
    }

    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", (Object)"chrome");
    }

    public boolean isSupporting(Capabilities capabilities) {
        return "chrome".equalsIgnoreCase(capabilities.getBrowserName()) || capabilities.getCapability("chromeOptions") != null || capabilities.getCapability("goog:chromeOptions") != null;
    }

    public boolean isSupportingCdp() {
        return true;
    }

    public boolean isAvailable() {
        try {
            ChromeDriverService.createDefaultService();
            return true;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable() || !this.isSupporting(capabilities)) {
            return Optional.empty();
        }
        ChromeDriver driver = new ChromeDriver(capabilities);
        return Optional.of(driver);
    }
}

