/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverService;

public class ChromiumDriverCommandExecutor
extends DriverCommandExecutor {
    private static Map<String, CommandInfo> buildChromiumCommandMappings(String vendorKeyword) {
        String sessionPrefix = "/session/:sessionId/";
        String chromiumPrefix = sessionPrefix + "chromium";
        String vendorPrefix = sessionPrefix + vendorKeyword;
        HashMap<String, CommandInfo> mappings = new HashMap<String, CommandInfo>();
        mappings.put("launchApp", new CommandInfo(chromiumPrefix + "/launch_app", HttpMethod.POST));
        String networkConditions = chromiumPrefix + "/network_conditions";
        mappings.put("getNetworkConditions", new CommandInfo(networkConditions, HttpMethod.GET));
        mappings.put("setNetworkConditions", new CommandInfo(networkConditions, HttpMethod.POST));
        mappings.put("deleteNetworkConditions", new CommandInfo(networkConditions, HttpMethod.DELETE));
        mappings.put("executeCdpCommand", new CommandInfo(vendorPrefix + "/cdp/execute", HttpMethod.POST));
        String cast = vendorPrefix + "/cast";
        mappings.put("getCastSinks", new CommandInfo(cast + "/get_sinks", HttpMethod.GET));
        mappings.put("selectCastSink", new CommandInfo(cast + "/set_sink_to_use", HttpMethod.POST));
        mappings.put("startCastTabMirroring", new CommandInfo(cast + "/start_tab_mirroring", HttpMethod.POST));
        mappings.put("getCastIssueMessage", new CommandInfo(cast + "/get_issue_message", HttpMethod.GET));
        mappings.put("stopCasting", new CommandInfo(cast + "/stop_casting", HttpMethod.POST));
        mappings.put("setPermission", new CommandInfo(sessionPrefix + "/permissions", HttpMethod.POST));
        return Collections.unmodifiableMap(mappings);
    }

    public ChromiumDriverCommandExecutor(String vendorPrefix, DriverService service) {
        super(service, ChromiumDriverCommandExecutor.buildChromiumCommandMappings(vendorPrefix));
    }
}

