/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v92.debugger;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v92.debugger.model.BreakLocation;
import org.openqa.selenium.devtools.v92.debugger.model.BreakpointId;
import org.openqa.selenium.devtools.v92.debugger.model.BreakpointResolved;
import org.openqa.selenium.devtools.v92.debugger.model.CallFrame;
import org.openqa.selenium.devtools.v92.debugger.model.CallFrameId;
import org.openqa.selenium.devtools.v92.debugger.model.Location;
import org.openqa.selenium.devtools.v92.debugger.model.LocationRange;
import org.openqa.selenium.devtools.v92.debugger.model.Paused;
import org.openqa.selenium.devtools.v92.debugger.model.ScriptFailedToParse;
import org.openqa.selenium.devtools.v92.debugger.model.ScriptParsed;
import org.openqa.selenium.devtools.v92.debugger.model.ScriptPosition;
import org.openqa.selenium.devtools.v92.debugger.model.SearchMatch;
import org.openqa.selenium.devtools.v92.runtime.model.CallArgument;
import org.openqa.selenium.devtools.v92.runtime.model.ExceptionDetails;
import org.openqa.selenium.devtools.v92.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v92.runtime.model.RemoteObjectId;
import org.openqa.selenium.devtools.v92.runtime.model.ScriptId;
import org.openqa.selenium.devtools.v92.runtime.model.StackTrace;
import org.openqa.selenium.devtools.v92.runtime.model.StackTraceId;
import org.openqa.selenium.devtools.v92.runtime.model.TimeDelta;
import org.openqa.selenium.devtools.v92.runtime.model.UniqueDebuggerId;
import org.openqa.selenium.json.JsonInput;

public class Debugger {
    public static Command<Void> continueToLocation(Location location, Optional<ContinueToLocationTargetCallFrames> targetCallFrames) {
        Objects.requireNonNull(location, "location is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"location", (Object)location);
        targetCallFrames.ifPresent(p -> params.put((Object)"targetCallFrames", (Object)p));
        return new Command("Debugger.continueToLocation", (Map)params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Debugger.disable", (Map)params.build());
    }

    public static Command<UniqueDebuggerId> enable(Optional<Number> maxScriptsCacheSize) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        maxScriptsCacheSize.ifPresent(p -> params.put((Object)"maxScriptsCacheSize", p));
        return new Command("Debugger.enable", (Map)params.build(), ConverterFunctions.map((String)"debuggerId", UniqueDebuggerId.class));
    }

    public static Command<EvaluateOnCallFrameResponse> evaluateOnCallFrame(CallFrameId callFrameId, String expression, Optional<String> objectGroup, Optional<Boolean> includeCommandLineAPI, Optional<Boolean> silent, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview, Optional<Boolean> throwOnSideEffect, Optional<TimeDelta> timeout) {
        Objects.requireNonNull(callFrameId, "callFrameId is required");
        Objects.requireNonNull(expression, "expression is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"callFrameId", (Object)callFrameId);
        params.put((Object)"expression", (Object)expression);
        objectGroup.ifPresent(p -> params.put((Object)"objectGroup", p));
        includeCommandLineAPI.ifPresent(p -> params.put((Object)"includeCommandLineAPI", p));
        silent.ifPresent(p -> params.put((Object)"silent", p));
        returnByValue.ifPresent(p -> params.put((Object)"returnByValue", p));
        generatePreview.ifPresent(p -> params.put((Object)"generatePreview", p));
        throwOnSideEffect.ifPresent(p -> params.put((Object)"throwOnSideEffect", p));
        timeout.ifPresent(p -> params.put((Object)"timeout", p));
        return new Command("Debugger.evaluateOnCallFrame", (Map)params.build(), input -> (EvaluateOnCallFrameResponse)input.read(EvaluateOnCallFrameResponse.class));
    }

    public static Command<List<BreakLocation>> getPossibleBreakpoints(Location start, Optional<Location> end, Optional<Boolean> restrictToFunction) {
        Objects.requireNonNull(start, "start is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"start", (Object)start);
        end.ifPresent(p -> params.put((Object)"end", p));
        restrictToFunction.ifPresent(p -> params.put((Object)"restrictToFunction", p));
        return new Command("Debugger.getPossibleBreakpoints", (Map)params.build(), ConverterFunctions.map((String)"locations", (Type)new TypeToken<List<BreakLocation>>(){}.getType()));
    }

    public static Command<GetScriptSourceResponse> getScriptSource(ScriptId scriptId) {
        Objects.requireNonNull(scriptId, "scriptId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"scriptId", (Object)scriptId);
        return new Command("Debugger.getScriptSource", (Map)params.build(), input -> (GetScriptSourceResponse)input.read(GetScriptSourceResponse.class));
    }

    @Deprecated
    public static Command<String> getWasmBytecode(ScriptId scriptId) {
        Objects.requireNonNull(scriptId, "scriptId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"scriptId", (Object)scriptId);
        return new Command("Debugger.getWasmBytecode", (Map)params.build(), ConverterFunctions.map((String)"bytecode", String.class));
    }

    @Beta
    public static Command<StackTrace> getStackTrace(StackTraceId stackTraceId) {
        Objects.requireNonNull(stackTraceId, "stackTraceId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"stackTraceId", (Object)stackTraceId);
        return new Command("Debugger.getStackTrace", (Map)params.build(), ConverterFunctions.map((String)"stackTrace", StackTrace.class));
    }

    public static Command<Void> pause() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Debugger.pause", (Map)params.build());
    }

    @Beta
    @Deprecated
    public static Command<Void> pauseOnAsyncCall(StackTraceId parentStackTraceId) {
        Objects.requireNonNull(parentStackTraceId, "parentStackTraceId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"parentStackTraceId", (Object)parentStackTraceId);
        return new Command("Debugger.pauseOnAsyncCall", (Map)params.build());
    }

    public static Command<Void> removeBreakpoint(BreakpointId breakpointId) {
        Objects.requireNonNull(breakpointId, "breakpointId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"breakpointId", (Object)breakpointId);
        return new Command("Debugger.removeBreakpoint", (Map)params.build());
    }

    @Deprecated
    public static Command<RestartFrameResponse> restartFrame(CallFrameId callFrameId) {
        Objects.requireNonNull(callFrameId, "callFrameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"callFrameId", (Object)callFrameId);
        return new Command("Debugger.restartFrame", (Map)params.build(), input -> (RestartFrameResponse)input.read(RestartFrameResponse.class));
    }

    public static Command<Void> resume(Optional<Boolean> terminateOnResume) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        terminateOnResume.ifPresent(p -> params.put((Object)"terminateOnResume", p));
        return new Command("Debugger.resume", (Map)params.build());
    }

    public static Command<List<SearchMatch>> searchInContent(ScriptId scriptId, String query, Optional<Boolean> caseSensitive, Optional<Boolean> isRegex) {
        Objects.requireNonNull(scriptId, "scriptId is required");
        Objects.requireNonNull(query, "query is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"scriptId", (Object)scriptId);
        params.put((Object)"query", (Object)query);
        caseSensitive.ifPresent(p -> params.put((Object)"caseSensitive", p));
        isRegex.ifPresent(p -> params.put((Object)"isRegex", p));
        return new Command("Debugger.searchInContent", (Map)params.build(), ConverterFunctions.map((String)"result", (Type)new TypeToken<List<SearchMatch>>(){}.getType()));
    }

    public static Command<Void> setAsyncCallStackDepth(Integer maxDepth) {
        Objects.requireNonNull(maxDepth, "maxDepth is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"maxDepth", (Object)maxDepth);
        return new Command("Debugger.setAsyncCallStackDepth", (Map)params.build());
    }

    @Beta
    public static Command<Void> setBlackboxPatterns(List<String> patterns) {
        Objects.requireNonNull(patterns, "patterns is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"patterns", patterns);
        return new Command("Debugger.setBlackboxPatterns", (Map)params.build());
    }

    @Beta
    public static Command<Void> setBlackboxedRanges(ScriptId scriptId, List<ScriptPosition> positions) {
        Objects.requireNonNull(scriptId, "scriptId is required");
        Objects.requireNonNull(positions, "positions is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"scriptId", (Object)scriptId);
        params.put((Object)"positions", positions);
        return new Command("Debugger.setBlackboxedRanges", (Map)params.build());
    }

    public static Command<SetBreakpointResponse> setBreakpoint(Location location, Optional<String> condition) {
        Objects.requireNonNull(location, "location is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"location", (Object)location);
        condition.ifPresent(p -> params.put((Object)"condition", p));
        return new Command("Debugger.setBreakpoint", (Map)params.build(), input -> (SetBreakpointResponse)input.read(SetBreakpointResponse.class));
    }

    public static Command<BreakpointId> setInstrumentationBreakpoint(SetInstrumentationBreakpointInstrumentation instrumentation) {
        Objects.requireNonNull(instrumentation, "instrumentation is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"instrumentation", (Object)instrumentation);
        return new Command("Debugger.setInstrumentationBreakpoint", (Map)params.build(), ConverterFunctions.map((String)"breakpointId", BreakpointId.class));
    }

    public static Command<SetBreakpointByUrlResponse> setBreakpointByUrl(Integer lineNumber, Optional<String> url, Optional<String> urlRegex, Optional<String> scriptHash, Optional<Integer> columnNumber, Optional<String> condition) {
        Objects.requireNonNull(lineNumber, "lineNumber is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"lineNumber", (Object)lineNumber);
        url.ifPresent(p -> params.put((Object)"url", p));
        urlRegex.ifPresent(p -> params.put((Object)"urlRegex", p));
        scriptHash.ifPresent(p -> params.put((Object)"scriptHash", p));
        columnNumber.ifPresent(p -> params.put((Object)"columnNumber", p));
        condition.ifPresent(p -> params.put((Object)"condition", p));
        return new Command("Debugger.setBreakpointByUrl", (Map)params.build(), input -> (SetBreakpointByUrlResponse)input.read(SetBreakpointByUrlResponse.class));
    }

    @Beta
    public static Command<BreakpointId> setBreakpointOnFunctionCall(RemoteObjectId objectId, Optional<String> condition) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectId", (Object)objectId);
        condition.ifPresent(p -> params.put((Object)"condition", p));
        return new Command("Debugger.setBreakpointOnFunctionCall", (Map)params.build(), ConverterFunctions.map((String)"breakpointId", BreakpointId.class));
    }

    public static Command<Void> setBreakpointsActive(Boolean active) {
        Objects.requireNonNull(active, "active is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"active", (Object)active);
        return new Command("Debugger.setBreakpointsActive", (Map)params.build());
    }

    public static Command<Void> setPauseOnExceptions(SetPauseOnExceptionsState state) {
        Objects.requireNonNull(state, "state is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"state", (Object)state);
        return new Command("Debugger.setPauseOnExceptions", (Map)params.build());
    }

    @Beta
    public static Command<Void> setReturnValue(CallArgument newValue) {
        Objects.requireNonNull(newValue, "newValue is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"newValue", (Object)newValue);
        return new Command("Debugger.setReturnValue", (Map)params.build());
    }

    public static Command<SetScriptSourceResponse> setScriptSource(ScriptId scriptId, String scriptSource, Optional<Boolean> dryRun) {
        Objects.requireNonNull(scriptId, "scriptId is required");
        Objects.requireNonNull(scriptSource, "scriptSource is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"scriptId", (Object)scriptId);
        params.put((Object)"scriptSource", (Object)scriptSource);
        dryRun.ifPresent(p -> params.put((Object)"dryRun", p));
        return new Command("Debugger.setScriptSource", (Map)params.build(), input -> (SetScriptSourceResponse)input.read(SetScriptSourceResponse.class));
    }

    public static Command<Void> setSkipAllPauses(Boolean skip) {
        Objects.requireNonNull(skip, "skip is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"skip", (Object)skip);
        return new Command("Debugger.setSkipAllPauses", (Map)params.build());
    }

    public static Command<Void> setVariableValue(Integer scopeNumber, String variableName, CallArgument newValue, CallFrameId callFrameId) {
        Objects.requireNonNull(scopeNumber, "scopeNumber is required");
        Objects.requireNonNull(variableName, "variableName is required");
        Objects.requireNonNull(newValue, "newValue is required");
        Objects.requireNonNull(callFrameId, "callFrameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"scopeNumber", (Object)scopeNumber);
        params.put((Object)"variableName", (Object)variableName);
        params.put((Object)"newValue", (Object)newValue);
        params.put((Object)"callFrameId", (Object)callFrameId);
        return new Command("Debugger.setVariableValue", (Map)params.build());
    }

    public static Command<Void> stepInto(Optional<Boolean> breakOnAsyncCall, Optional<List<LocationRange>> skipList) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        breakOnAsyncCall.ifPresent(p -> params.put((Object)"breakOnAsyncCall", p));
        skipList.ifPresent(p -> params.put((Object)"skipList", p));
        return new Command("Debugger.stepInto", (Map)params.build());
    }

    public static Command<Void> stepOut() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Debugger.stepOut", (Map)params.build());
    }

    public static Command<Void> stepOver(Optional<List<LocationRange>> skipList) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        skipList.ifPresent(p -> params.put((Object)"skipList", p));
        return new Command("Debugger.stepOver", (Map)params.build());
    }

    public static Event<BreakpointResolved> breakpointResolved() {
        return new Event("Debugger.breakpointResolved", input -> (BreakpointResolved)input.read(BreakpointResolved.class));
    }

    public static Event<Paused> paused() {
        return new Event("Debugger.paused", input -> (Paused)input.read(Paused.class));
    }

    public static Event<Void> resumed() {
        return new Event("Debugger.resumed", input -> null);
    }

    public static Event<ScriptFailedToParse> scriptFailedToParse() {
        return new Event("Debugger.scriptFailedToParse", input -> (ScriptFailedToParse)input.read(ScriptFailedToParse.class));
    }

    public static Event<ScriptParsed> scriptParsed() {
        return new Event("Debugger.scriptParsed", input -> (ScriptParsed)input.read(ScriptParsed.class));
    }

    public static class SetScriptSourceResponse {
        private final Optional<List<CallFrame>> callFrames;
        private final Optional<Boolean> stackChanged;
        private final Optional<StackTrace> asyncStackTrace;
        private final Optional<StackTraceId> asyncStackTraceId;
        private final Optional<ExceptionDetails> exceptionDetails;

        public SetScriptSourceResponse(Optional<List<CallFrame>> callFrames, Optional<Boolean> stackChanged, Optional<StackTrace> asyncStackTrace, Optional<StackTraceId> asyncStackTraceId, Optional<ExceptionDetails> exceptionDetails) {
            this.callFrames = callFrames;
            this.stackChanged = stackChanged;
            this.asyncStackTrace = asyncStackTrace;
            this.asyncStackTraceId = asyncStackTraceId;
            this.exceptionDetails = exceptionDetails;
        }

        public Optional<List<CallFrame>> getCallFrames() {
            return this.callFrames;
        }

        public Optional<Boolean> getStackChanged() {
            return this.stackChanged;
        }

        public Optional<StackTrace> getAsyncStackTrace() {
            return this.asyncStackTrace;
        }

        public Optional<StackTraceId> getAsyncStackTraceId() {
            return this.asyncStackTraceId;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static SetScriptSourceResponse fromJson(JsonInput input) {
            Optional<List<CallFrame>> callFrames = Optional.empty();
            Optional<Boolean> stackChanged = Optional.empty();
            Optional<StackTrace> asyncStackTrace = Optional.empty();
            Optional<StackTraceId> asyncStackTraceId = Optional.empty();
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block14: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "callFrames": {
                        callFrames = Optional.ofNullable((List)input.read(new TypeToken<List<CallFrame>>(){}.getType()));
                        continue block14;
                    }
                    case "stackChanged": {
                        stackChanged = Optional.ofNullable(input.nextBoolean());
                        continue block14;
                    }
                    case "asyncStackTrace": {
                        asyncStackTrace = Optional.ofNullable((StackTrace)input.read(StackTrace.class));
                        continue block14;
                    }
                    case "asyncStackTraceId": {
                        asyncStackTraceId = Optional.ofNullable((StackTraceId)input.read(StackTraceId.class));
                        continue block14;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block14;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new SetScriptSourceResponse(callFrames, stackChanged, asyncStackTrace, asyncStackTraceId, exceptionDetails);
        }
    }

    public static enum SetPauseOnExceptionsState {
        NONE("none"),
        UNCAUGHT("uncaught"),
        ALL("all");

        private String value;

        private SetPauseOnExceptionsState(String value) {
            this.value = value;
        }

        public static SetPauseOnExceptionsState fromString(String s) {
            return Arrays.stream(SetPauseOnExceptionsState.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetPauseOnExceptionsState "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetPauseOnExceptionsState fromJson(JsonInput input) {
            return SetPauseOnExceptionsState.fromString(input.nextString());
        }
    }

    public static class SetBreakpointByUrlResponse {
        private final BreakpointId breakpointId;
        private final List<Location> locations;

        public SetBreakpointByUrlResponse(BreakpointId breakpointId, List<Location> locations) {
            this.breakpointId = Objects.requireNonNull(breakpointId, "breakpointId is required");
            this.locations = Objects.requireNonNull(locations, "locations is required");
        }

        public BreakpointId getBreakpointId() {
            return this.breakpointId;
        }

        public List<Location> getLocations() {
            return this.locations;
        }

        private static SetBreakpointByUrlResponse fromJson(JsonInput input) {
            BreakpointId breakpointId = null;
            List locations = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "breakpointId": {
                        breakpointId = (BreakpointId)input.read(BreakpointId.class);
                        continue block8;
                    }
                    case "locations": {
                        locations = (List)input.read(new TypeToken<List<Location>>(){}.getType());
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new SetBreakpointByUrlResponse(breakpointId, locations);
        }
    }

    public static enum SetInstrumentationBreakpointInstrumentation {
        BEFORESCRIPTEXECUTION("beforeScriptExecution"),
        BEFORESCRIPTWITHSOURCEMAPEXECUTION("beforeScriptWithSourceMapExecution");

        private String value;

        private SetInstrumentationBreakpointInstrumentation(String value) {
            this.value = value;
        }

        public static SetInstrumentationBreakpointInstrumentation fromString(String s) {
            return Arrays.stream(SetInstrumentationBreakpointInstrumentation.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetInstrumentationBreakpointInstrumentation "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetInstrumentationBreakpointInstrumentation fromJson(JsonInput input) {
            return SetInstrumentationBreakpointInstrumentation.fromString(input.nextString());
        }
    }

    public static class SetBreakpointResponse {
        private final BreakpointId breakpointId;
        private final Location actualLocation;

        public SetBreakpointResponse(BreakpointId breakpointId, Location actualLocation) {
            this.breakpointId = Objects.requireNonNull(breakpointId, "breakpointId is required");
            this.actualLocation = Objects.requireNonNull(actualLocation, "actualLocation is required");
        }

        public BreakpointId getBreakpointId() {
            return this.breakpointId;
        }

        public Location getActualLocation() {
            return this.actualLocation;
        }

        private static SetBreakpointResponse fromJson(JsonInput input) {
            BreakpointId breakpointId = null;
            Location actualLocation = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "breakpointId": {
                        breakpointId = (BreakpointId)input.read(BreakpointId.class);
                        continue block8;
                    }
                    case "actualLocation": {
                        actualLocation = (Location)input.read(Location.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new SetBreakpointResponse(breakpointId, actualLocation);
        }
    }

    public static class RestartFrameResponse {
        private final List<CallFrame> callFrames;
        private final Optional<StackTrace> asyncStackTrace;
        private final Optional<StackTraceId> asyncStackTraceId;

        public RestartFrameResponse(List<CallFrame> callFrames, Optional<StackTrace> asyncStackTrace, Optional<StackTraceId> asyncStackTraceId) {
            this.callFrames = Objects.requireNonNull(callFrames, "callFrames is required");
            this.asyncStackTrace = asyncStackTrace;
            this.asyncStackTraceId = asyncStackTraceId;
        }

        public List<CallFrame> getCallFrames() {
            return this.callFrames;
        }

        public Optional<StackTrace> getAsyncStackTrace() {
            return this.asyncStackTrace;
        }

        public Optional<StackTraceId> getAsyncStackTraceId() {
            return this.asyncStackTraceId;
        }

        private static RestartFrameResponse fromJson(JsonInput input) {
            List callFrames = null;
            Optional<StackTrace> asyncStackTrace = Optional.empty();
            Optional<StackTraceId> asyncStackTraceId = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "callFrames": {
                        callFrames = (List)input.read(new TypeToken<List<CallFrame>>(){}.getType());
                        continue block10;
                    }
                    case "asyncStackTrace": {
                        asyncStackTrace = Optional.ofNullable((StackTrace)input.read(StackTrace.class));
                        continue block10;
                    }
                    case "asyncStackTraceId": {
                        asyncStackTraceId = Optional.ofNullable((StackTraceId)input.read(StackTraceId.class));
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RestartFrameResponse(callFrames, asyncStackTrace, asyncStackTraceId);
        }
    }

    public static class GetScriptSourceResponse {
        private final String scriptSource;
        private final Optional<String> bytecode;

        public GetScriptSourceResponse(String scriptSource, Optional<String> bytecode) {
            this.scriptSource = Objects.requireNonNull(scriptSource, "scriptSource is required");
            this.bytecode = bytecode;
        }

        public String getScriptSource() {
            return this.scriptSource;
        }

        public Optional<String> getBytecode() {
            return this.bytecode;
        }

        private static GetScriptSourceResponse fromJson(JsonInput input) {
            String scriptSource = null;
            Optional<String> bytecode = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "scriptSource": {
                        scriptSource = input.nextString();
                        continue block8;
                    }
                    case "bytecode": {
                        bytecode = Optional.ofNullable(input.nextString());
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetScriptSourceResponse(scriptSource, bytecode);
        }
    }

    public static class EvaluateOnCallFrameResponse {
        private final RemoteObject result;
        private final Optional<ExceptionDetails> exceptionDetails;

        public EvaluateOnCallFrameResponse(RemoteObject result, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static EvaluateOnCallFrameResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read(RemoteObject.class);
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read(ExceptionDetails.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new EvaluateOnCallFrameResponse(result, exceptionDetails);
        }
    }

    public static enum ContinueToLocationTargetCallFrames {
        ANY("any"),
        CURRENT("current");

        private String value;

        private ContinueToLocationTargetCallFrames(String value) {
            this.value = value;
        }

        public static ContinueToLocationTargetCallFrames fromString(String s) {
            return Arrays.stream(ContinueToLocationTargetCallFrames.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within ContinueToLocationTargetCallFrames "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static ContinueToLocationTargetCallFrames fromJson(JsonInput input) {
            return ContinueToLocationTargetCallFrames.fromString(input.nextString());
        }
    }
}

