/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v92.domdebugger.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum CSPViolationType {
    TRUSTEDTYPE_SINK_VIOLATION("trustedtype-sink-violation"),
    TRUSTEDTYPE_POLICY_VIOLATION("trustedtype-policy-violation");

    private String value;

    private CSPViolationType(String value) {
        this.value = value;
    }

    public static CSPViolationType fromString(String s) {
        return Arrays.stream(CSPViolationType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within CSPViolationType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static CSPViolationType fromJson(JsonInput input) {
        return CSPViolationType.fromString(input.nextString());
    }
}

