/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v92.input.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v92.input.model.DragDataItem;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DragData {
    private final List<DragDataItem> items;
    private final Integer dragOperationsMask;

    public DragData(List<DragDataItem> items, Integer dragOperationsMask) {
        this.items = Objects.requireNonNull(items, "items is required");
        this.dragOperationsMask = Objects.requireNonNull(dragOperationsMask, "dragOperationsMask is required");
    }

    public List<DragDataItem> getItems() {
        return this.items;
    }

    public Integer getDragOperationsMask() {
        return this.dragOperationsMask;
    }

    private static DragData fromJson(JsonInput input) {
        List items = null;
        Integer dragOperationsMask = 0;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "items": {
                    items = (List)input.read(new TypeToken<List<DragDataItem>>(){}.getType());
                    continue block8;
                }
                case "dragOperationsMask": {
                    dragOperationsMask = input.nextNumber().intValue();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DragData(items, dragOperationsMask);
    }
}

