/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v92.network.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum IPAddressSpace {
    LOCAL("Local"),
    PRIVATE("Private"),
    PUBLIC("Public"),
    UNKNOWN("Unknown");

    private String value;

    private IPAddressSpace(String value) {
        this.value = value;
    }

    public static IPAddressSpace fromString(String s) {
        return Arrays.stream(IPAddressSpace.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within IPAddressSpace "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static IPAddressSpace fromJson(JsonInput input) {
        return IPAddressSpace.fromString(input.nextString());
    }
}

