/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v92.page.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class LayoutViewport {
    private final Integer pageX;
    private final Integer pageY;
    private final Integer clientWidth;
    private final Integer clientHeight;

    public LayoutViewport(Integer pageX, Integer pageY, Integer clientWidth, Integer clientHeight) {
        this.pageX = Objects.requireNonNull(pageX, "pageX is required");
        this.pageY = Objects.requireNonNull(pageY, "pageY is required");
        this.clientWidth = Objects.requireNonNull(clientWidth, "clientWidth is required");
        this.clientHeight = Objects.requireNonNull(clientHeight, "clientHeight is required");
    }

    public Integer getPageX() {
        return this.pageX;
    }

    public Integer getPageY() {
        return this.pageY;
    }

    public Integer getClientWidth() {
        return this.clientWidth;
    }

    public Integer getClientHeight() {
        return this.clientHeight;
    }

    private static LayoutViewport fromJson(JsonInput input) {
        Integer pageX = 0;
        Integer pageY = 0;
        Integer clientWidth = 0;
        Integer clientHeight = 0;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "pageX": {
                    pageX = input.nextNumber().intValue();
                    continue block12;
                }
                case "pageY": {
                    pageY = input.nextNumber().intValue();
                    continue block12;
                }
                case "clientWidth": {
                    clientWidth = input.nextNumber().intValue();
                    continue block12;
                }
                case "clientHeight": {
                    clientHeight = input.nextNumber().intValue();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LayoutViewport(pageX, pageY, clientWidth, clientHeight);
    }
}

