/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v92.page.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v92.network.model.LoaderId;
import org.openqa.selenium.devtools.v92.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v92.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class LifecycleEvent {
    private final FrameId frameId;
    private final LoaderId loaderId;
    private final String name;
    private final MonotonicTime timestamp;

    public LifecycleEvent(FrameId frameId, LoaderId loaderId, String name, MonotonicTime timestamp) {
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public String getName() {
        return this.name;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    private static LifecycleEvent fromJson(JsonInput input) {
        FrameId frameId = null;
        LoaderId loaderId = null;
        String name = null;
        MonotonicTime timestamp = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block12;
                }
                case "loaderId": {
                    loaderId = (LoaderId)input.read(LoaderId.class);
                    continue block12;
                }
                case "name": {
                    name = input.nextString();
                    continue block12;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LifecycleEvent(frameId, loaderId, name, timestamp);
    }
}

