/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v92.runtime.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v92.runtime.model.CallFrame;
import org.openqa.selenium.devtools.v92.runtime.model.StackTraceId;
import org.openqa.selenium.json.JsonInput;

public class StackTrace {
    private final Optional<String> description;
    private final List<CallFrame> callFrames;
    private final Optional<StackTrace> parent;
    private final Optional<StackTraceId> parentId;

    public StackTrace(Optional<String> description, List<CallFrame> callFrames, Optional<StackTrace> parent, Optional<StackTraceId> parentId) {
        this.description = description;
        this.callFrames = Objects.requireNonNull(callFrames, "callFrames is required");
        this.parent = parent;
        this.parentId = parentId;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public List<CallFrame> getCallFrames() {
        return this.callFrames;
    }

    public Optional<StackTrace> getParent() {
        return this.parent;
    }

    @Beta
    public Optional<StackTraceId> getParentId() {
        return this.parentId;
    }

    private static StackTrace fromJson(JsonInput input) {
        Optional<String> description = Optional.empty();
        List callFrames = null;
        Optional<StackTrace> parent = Optional.empty();
        Optional<StackTraceId> parentId = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "description": {
                    description = Optional.ofNullable(input.nextString());
                    continue block12;
                }
                case "callFrames": {
                    callFrames = (List)input.read(new TypeToken<List<CallFrame>>(){}.getType());
                    continue block12;
                }
                case "parent": {
                    parent = Optional.ofNullable((StackTrace)input.read(StackTrace.class));
                    continue block12;
                }
                case "parentId": {
                    parentId = Optional.ofNullable((StackTraceId)input.read(StackTraceId.class));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new StackTrace(description, callFrames, parent, parentId);
    }
}

