/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v92.webauthn;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v92.webauthn.model.AuthenticatorId;
import org.openqa.selenium.devtools.v92.webauthn.model.Credential;
import org.openqa.selenium.devtools.v92.webauthn.model.VirtualAuthenticatorOptions;

@Beta
public class WebAuthn {
    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("WebAuthn.enable", (Map)params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("WebAuthn.disable", (Map)params.build());
    }

    public static Command<AuthenticatorId> addVirtualAuthenticator(VirtualAuthenticatorOptions options) {
        Objects.requireNonNull(options, "options is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"options", (Object)options);
        return new Command("WebAuthn.addVirtualAuthenticator", (Map)params.build(), ConverterFunctions.map((String)"authenticatorId", AuthenticatorId.class));
    }

    public static Command<Void> removeVirtualAuthenticator(AuthenticatorId authenticatorId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"authenticatorId", (Object)authenticatorId);
        return new Command("WebAuthn.removeVirtualAuthenticator", (Map)params.build());
    }

    public static Command<Void> addCredential(AuthenticatorId authenticatorId, Credential credential) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(credential, "credential is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"authenticatorId", (Object)authenticatorId);
        params.put((Object)"credential", (Object)credential);
        return new Command("WebAuthn.addCredential", (Map)params.build());
    }

    public static Command<Credential> getCredential(AuthenticatorId authenticatorId, String credentialId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(credentialId, "credentialId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"authenticatorId", (Object)authenticatorId);
        params.put((Object)"credentialId", (Object)credentialId);
        return new Command("WebAuthn.getCredential", (Map)params.build(), ConverterFunctions.map((String)"credential", Credential.class));
    }

    public static Command<List<Credential>> getCredentials(AuthenticatorId authenticatorId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"authenticatorId", (Object)authenticatorId);
        return new Command("WebAuthn.getCredentials", (Map)params.build(), ConverterFunctions.map((String)"credentials", (Type)new TypeToken<List<Credential>>(){}.getType()));
    }

    public static Command<Void> removeCredential(AuthenticatorId authenticatorId, String credentialId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(credentialId, "credentialId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"authenticatorId", (Object)authenticatorId);
        params.put((Object)"credentialId", (Object)credentialId);
        return new Command("WebAuthn.removeCredential", (Map)params.build());
    }

    public static Command<Void> clearCredentials(AuthenticatorId authenticatorId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"authenticatorId", (Object)authenticatorId);
        return new Command("WebAuthn.clearCredentials", (Map)params.build());
    }

    public static Command<Void> setUserVerified(AuthenticatorId authenticatorId, Boolean isUserVerified) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(isUserVerified, "isUserVerified is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"authenticatorId", (Object)authenticatorId);
        params.put((Object)"isUserVerified", (Object)isUserVerified);
        return new Command("WebAuthn.setUserVerified", (Map)params.build());
    }

    public static Command<Void> setAutomaticPresenceSimulation(AuthenticatorId authenticatorId, Boolean enabled) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"authenticatorId", (Object)authenticatorId);
        params.put((Object)"enabled", (Object)enabled);
        return new Command("WebAuthn.setAutomaticPresenceSimulation", (Map)params.build());
    }
}

