/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.core.AttributeParameter;
import org.simpleframework.xml.core.ElementArrayParameter;
import org.simpleframework.xml.core.ElementListParameter;
import org.simpleframework.xml.core.ElementMapParameter;
import org.simpleframework.xml.core.ElementParameter;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.PersistenceException;

final class ParameterFactory {
    ParameterFactory() {
    }

    public static Parameter getInstance(Constructor method, Annotation label, int index) throws Exception {
        Constructor factory = ParameterFactory.getConstructor(label);
        if (!factory.isAccessible()) {
            factory.setAccessible(true);
        }
        return (Parameter)factory.newInstance(method, label, index);
    }

    private static Constructor getConstructor(Annotation label) throws Exception {
        return ParameterFactory.getEntry(label).getConstructor();
    }

    private static Entry getEntry(Annotation label) throws Exception {
        if (label instanceof Element) {
            return new Entry(ElementParameter.class, Element.class);
        }
        if (label instanceof ElementList) {
            return new Entry(ElementListParameter.class, ElementList.class);
        }
        if (label instanceof ElementArray) {
            return new Entry(ElementArrayParameter.class, ElementArray.class);
        }
        if (label instanceof ElementMap) {
            return new Entry(ElementMapParameter.class, ElementMap.class);
        }
        if (label instanceof Attribute) {
            return new Entry(AttributeParameter.class, Attribute.class);
        }
        throw new PersistenceException("Annotation %s not supported", label);
    }

    private static class Entry {
        public Class create;
        public Class type;

        public Entry(Class create, Class type) {
            this.create = create;
            this.type = type;
        }

        public Constructor getConstructor() throws Exception {
            return this.getConstructor(Constructor.class, this.type, Integer.TYPE);
        }

        private Constructor getConstructor(Class ... types) throws Exception {
            return this.create.getConstructor(types);
        }
    }
}

