/*
 * Resource.java February 2001
 *
 * Copyright (C) 2001, Niall Gallagher <niallg@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General 
 * Public License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA  02111-1307  USA
 */
 
package org.simpleframework.http.resource;

import org.simpleframework.http.Response;
import org.simpleframework.http.Request;

/**
 * A <code>Resource</code> provides an abstraction of any given 
 * object that can be retrieved using a HTTP request. The reason
 * for having this abstraction is to simplify the interface with 
 * any given <code>Resource</code>. 
 * <p>
 * This is similar in design to a <code>Container</code>, however
 * this is intended to handle a single resource. At any time a
 * container may manage many resources all of which are resolved
 * using a <code>ResourceEngine</code> implementation. So in 
 * essence this is used to identify a component that can handle
 * a HTTP request routed by a resource engine.
 *
 * @author Niall Gallagher
 */ 
public interface Resource {

   /**
    * This acts as the main processing method for the resources.
    * Implementations are required to provide the functions that 
    * will process the <code>Request</code> and generate a suitable
    * response for that request. This method is also responsible
    * for closing and comitting the <code>Response</code> unless
    * handed (chained) to another <code>Resource</code>.
    *
    * @param req the <code>Request</code> to be processed
    * @param resp the <code>Response</code> to be processed    
    */
   public void handle(Request req, Response resp);
}
