/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.SymbolicValue;

public class LogicalNotSymbolicValue
implements SymbolicValue {
    private final SymbolicValue negatedValue;

    private LogicalNotSymbolicValue(SymbolicValue negatedValue) {
        Preconditions.checkArgument((negatedValue != null ? 1 : 0) != 0, (Object)"negatedValue should not be null");
        this.negatedValue = negatedValue;
    }

    public static SymbolicValue create(SymbolicValue negatedValue) {
        return new LogicalNotSymbolicValue(negatedValue);
    }

    @Override
    public Optional<ProgramState> constrainDependencies(ProgramState state, Constraint constraint) {
        if (constraint.isStricterOrEqualTo(Constraint.TRUTHY)) {
            return state.constrain(this.negatedValue, Constraint.FALSY);
        }
        if (constraint.isStricterOrEqualTo(Constraint.FALSY)) {
            return state.constrain(this.negatedValue, Constraint.TRUTHY);
        }
        return Optional.of(state);
    }

    @Override
    public Constraint baseConstraint(ProgramState state) {
        Constraint negatedConstraint = state.getConstraint(this.negatedValue);
        if (negatedConstraint.isStricterOrEqualTo(Constraint.TRUTHY)) {
            return Constraint.FALSE;
        }
        if (negatedConstraint.isStricterOrEqualTo(Constraint.FALSY)) {
            return Constraint.TRUE;
        }
        return Constraint.BOOLEAN_PRIMITIVE;
    }

    public SymbolicValue negatedValue() {
        return this.negatedValue;
    }

    public String toString() {
        return "!" + this.negatedValue;
    }
}

