/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.declaration;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.SeparatedList;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ArrayBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class ArrayBindingPatternTreeImpl
extends JavaScriptTree
implements ArrayBindingPatternTree {
    private final InternalSyntaxToken openBracketToken;
    private final SeparatedList<Optional<BindingElementTree>> elements;
    private final InternalSyntaxToken closeBracketToken;

    public ArrayBindingPatternTreeImpl(InternalSyntaxToken openBracketToken, SeparatedList<Optional<BindingElementTree>> elements, InternalSyntaxToken closeBracketToken) {
        this.openBracketToken = openBracketToken;
        this.elements = elements;
        this.closeBracketToken = closeBracketToken;
    }

    @Override
    public InternalSyntaxToken openBracketToken() {
        return this.openBracketToken;
    }

    @Override
    public SeparatedList<Optional<BindingElementTree>> elements() {
        return this.elements;
    }

    @Override
    public InternalSyntaxToken closeBracketToken() {
        return this.closeBracketToken;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ARRAY_BINDING_PATTERN;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.openBracketToken), this.elements.elementsAndSeparators(new ElidedElementFilter()), (Iterator)Iterators.singletonIterator((Object)this.closeBracketToken));
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitArrayBindingPattern(this);
    }

    @Override
    public List<IdentifierTree> bindingIdentifiers() {
        ArrayList bindingIdentifiers = Lists.newArrayList();
        for (Optional optional : this.elements) {
            optional.ifPresent(bindingElementTree -> bindingIdentifiers.addAll(bindingElementTree.bindingIdentifiers()));
        }
        return bindingIdentifiers;
    }

    private static class ElidedElementFilter
    implements Function<Optional<BindingElementTree>, BindingElementTree> {
        private ElidedElementFilter() {
        }

        public BindingElementTree apply(Optional<BindingElementTree> e) {
            return e.orElse(null);
        }
    }
}

