/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.config.Settings;
import org.sonar.javascript.tree.symbols.HoistedSymbolVisitor;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.javascript.tree.symbols.ScopeVisitor;
import org.sonar.javascript.tree.symbols.SymbolModelBuilder;
import org.sonar.javascript.tree.symbols.SymbolVisitor;
import org.sonar.javascript.tree.symbols.type.TypeVisitor;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;

public class SymbolModelImpl
implements SymbolModel,
SymbolModelBuilder {
    private Set<Symbol> symbols = new HashSet<Symbol>();
    private Set<Scope> scopes = new HashSet<Scope>();
    private Scope globalScope;

    public static void build(TreeVisitorContext context, @Nullable Settings settings) {
        Map<Tree, Scope> treeScopeMap = SymbolModelImpl.getScopes(context);
        new HoistedSymbolVisitor(treeScopeMap, settings).scanTree(context);
        new SymbolVisitor(treeScopeMap).scanTree(context);
        new TypeVisitor(settings).scanTree(context);
    }

    private static Map<Tree, Scope> getScopes(TreeVisitorContext context) {
        ScopeVisitor scopeVisitor = new ScopeVisitor();
        scopeVisitor.scanTree(context);
        return scopeVisitor.getTreeScopeMap();
    }

    @Override
    public Scope globalScope() {
        return this.globalScope;
    }

    @Override
    public void addScope(Scope scope) {
        if (this.scopes.isEmpty()) {
            this.globalScope = scope;
        }
        this.scopes.add(scope);
    }

    @Override
    public Set<Scope> getScopes() {
        return this.scopes;
    }

    @Override
    public Symbol declareSymbol(String name, Symbol.Kind kind, Scope scope) {
        Symbol symbol = scope.getSymbol(name);
        if (symbol == null) {
            symbol = new Symbol(name, kind, scope);
            scope.addSymbol(symbol);
            this.symbols.add(symbol);
        } else if (kind.equals((Object)Symbol.Kind.FUNCTION)) {
            symbol.setKind(Symbol.Kind.FUNCTION);
        }
        return symbol;
    }

    @Override
    public Symbol declareExternalSymbol(String name, Symbol.Kind kind, Scope scope) {
        Symbol symbol = scope.getSymbol(name);
        if (symbol == null) {
            symbol = new Symbol(name, kind, scope);
            symbol.setExternal(true);
            scope.addSymbol(symbol);
            this.symbols.add(symbol);
        }
        return symbol;
    }

    @Override
    public Set<Symbol> getSymbols() {
        return Collections.unmodifiableSet(this.symbols);
    }

    @Override
    public Set<Symbol> getSymbols(Symbol.Kind kind) {
        HashSet<Symbol> result = new HashSet<Symbol>();
        for (Symbol symbol : this.symbols) {
            if (!kind.equals((Object)symbol.kind())) continue;
            result.add(symbol);
        }
        return result;
    }

    @Override
    public Set<Symbol> getSymbols(String name) {
        HashSet<Symbol> result = new HashSet<Symbol>();
        for (Symbol symbol : this.symbols) {
            if (!name.equals(symbol.name())) continue;
            result.add(symbol);
        }
        return result;
    }

    @Override
    @Nullable
    public Scope getScope(Tree tree) {
        for (Scope scope : this.getScopes()) {
            if (!scope.tree().equals(tree)) continue;
            return scope;
        }
        return null;
    }
}

