/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols.type;

import javax.annotation.Nullable;
import org.sonar.javascript.tree.symbols.type.ClassType;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Type;

public class ObjectType
implements Type {
    protected Type.Callability callability;
    protected ClassType classType = null;

    protected ObjectType(Type.Callability callability) {
        this.callability = callability;
    }

    public void classType(ClassType classType) {
        this.classType = classType;
    }

    @Override
    public Type.Kind kind() {
        return Type.Kind.OBJECT;
    }

    @Override
    public Type.Callability callability() {
        return this.callability;
    }

    @Nullable
    public ClassType classType() {
        return this.classType;
    }

    public static ObjectType create() {
        return ObjectType.create(Type.Callability.UNKNOWN);
    }

    public static ObjectType create(Type.Callability callability) {
        return new ObjectType(callability);
    }

    @Nullable
    public Symbol property(String name) {
        if (this.classType != null) {
            return this.classType.property(name);
        }
        return null;
    }

    public String toString() {
        return this.kind().name();
    }

    public static enum WebApiType implements Type
    {
        WINDOW{

            @Override
            public Type.Kind kind() {
                return Type.Kind.WINDOW;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.NON_CALLABLE;
            }
        }
        ,
        DOCUMENT{

            @Override
            public Type.Kind kind() {
                return Type.Kind.DOCUMENT;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.NON_CALLABLE;
            }
        }
        ,
        DOM_ELEMENT{

            @Override
            public Type.Kind kind() {
                return Type.Kind.DOM_ELEMENT;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.NON_CALLABLE;
            }
        };

    }

    public static enum BuiltInObjectType implements Type
    {
        DATE{

            @Override
            public Type.Kind kind() {
                return Type.Kind.DATE;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.NON_CALLABLE;
            }
        };

    }

    public static enum FrameworkType implements Type
    {
        JQUERY_SELECTOR_OBJECT{

            @Override
            public Type.Kind kind() {
                return Type.Kind.JQUERY_SELECTOR_OBJECT;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.NON_CALLABLE;
            }
        }
        ,
        JQUERY_OBJECT{

            @Override
            public Type.Kind kind() {
                return Type.Kind.JQUERY_OBJECT;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.CALLABLE;
            }
        }
        ,
        BACKBONE_MODEL{

            @Override
            public Type.Kind kind() {
                return Type.Kind.BACKBONE_MODEL;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.CALLABLE;
            }
        }
        ,
        BACKBONE_MODEL_OBJECT{

            @Override
            public Type.Kind kind() {
                return Type.Kind.BACKBONE_MODEL_OBJECT;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.UNKNOWN;
            }
        }
        ,
        ANGULAR_MODULE{

            @Override
            public Type.Kind kind() {
                return Type.Kind.ANGULAR_MODULE;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.NON_CALLABLE;
            }
        };

    }
}

