/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2050")
public class AliasFunctionUsageCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2050";
    public static final String MESSAGE = "Replace this use of \"%s\" with \"%s\".";
    private static final Map<String, String> ALIAS_FUNCTIONS = ImmutableMap.builder().put((Object)"chop", (Object)"rtrim").put((Object)"close", (Object)"closedir").put((Object)"doubleval", (Object)"floatval").put((Object)"fputs", (Object)"fwrite").put((Object)"ini_alter", (Object)"ini_set").put((Object)"is_double", (Object)"is_float").put((Object)"is_integer", (Object)"is_int").put((Object)"is_long", (Object)"is_int").put((Object)"is_real", (Object)"is_float").put((Object)"is_writeable", (Object)"is_writable").put((Object)"join", (Object)"implode").put((Object)"key_exists", (Object)"array_key_exists").put((Object)"magic_quotes_runtime", (Object)"set_magic_quotes_runtime").put((Object)"pos", (Object)"current").put((Object)"show_source", (Object)"highlight_file").put((Object)"sizeof", (Object)"count").put((Object)"strchr", (Object)"strstr").build();

    public void visitFunctionCall(FunctionCallTree tree) {
        String name;
        String replacementName;
        ExpressionTree callee = tree.callee();
        if (callee.is(new Tree.Kind[]{Tree.Kind.NAMESPACE_NAME}) && (replacementName = ALIAS_FUNCTIONS.get((name = ((NamespaceNameTree)callee).fullName()).toLowerCase(Locale.ROOT))) != null) {
            this.context().newIssue((PHPCheck)this, (Tree)callee, String.format(MESSAGE, name, replacementName));
        }
        super.visitFunctionCall(tree);
    }
}

