/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S121")
public class AlwaysUseCurlyBracesCheck
extends PHPVisitorCheck {
    public static final String KEY = "S121";
    private static final String MESSAGE = "Add curly braces around the nested statement(s).";

    private void checkStatement(StatementTree statementTree, Tree statementKeyword) {
        if (!statementTree.is(new Tree.Kind[]{Tree.Kind.BLOCK}) && !statementTree.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT})) {
            this.context().newIssue((PHPCheck)this, statementKeyword, MESSAGE);
        }
    }

    public void visitIfStatement(IfStatementTree tree) {
        super.visitIfStatement(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            this.checkStatement((StatementTree)tree.statements().get(0), (Tree)tree.ifToken());
        }
    }

    public void visitElseifClause(ElseifClauseTree tree) {
        super.visitElseifClause(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.ELSEIF_CLAUSE})) {
            this.checkStatement((StatementTree)tree.statements().get(0), (Tree)tree.elseifToken());
        }
    }

    public void visitElseClause(ElseClauseTree tree) {
        super.visitElseClause(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.ELSE_CLAUSE}) && !((StatementTree)tree.statements().get(0)).is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            this.checkStatement((StatementTree)tree.statements().get(0), (Tree)tree.elseToken());
        }
    }

    public void visitForStatement(ForStatementTree tree) {
        super.visitForStatement(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.FOR_STATEMENT})) {
            this.checkStatement((StatementTree)tree.statements().get(0), (Tree)tree.forToken());
        }
    }

    public void visitForEachStatement(ForEachStatementTree tree) {
        super.visitForEachStatement(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.FOREACH_STATEMENT})) {
            this.checkStatement((StatementTree)tree.statements().get(0), (Tree)tree.foreachToken());
        }
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        super.visitDoWhileStatement(tree);
        this.checkStatement(tree.statement(), (Tree)tree.doToken());
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        super.visitWhileStatement(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.WHILE_STATEMENT})) {
            this.checkStatement((StatementTree)tree.statements().get(0), (Tree)tree.whileToken());
        }
    }
}

