/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1788")
public class ArgumentWithDefaultValueNotLastCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1788";
    private static final String MESSAGE = "Move arguments %s after arguments without default value";

    public void visitParameterList(ParameterListTree parameterList) {
        List<ParameterTree> parametersToMove = ArgumentWithDefaultValueNotLastCheck.getParametersToMove(parameterList);
        if (!parametersToMove.isEmpty() && !ArgumentWithDefaultValueNotLastCheck.isVariableLengthParameterList(parameterList)) {
            this.context().newIssue((PHPCheck)this, (Tree)parameterList, String.format(MESSAGE, ArgumentWithDefaultValueNotLastCheck.getNameListString(parametersToMove)));
        }
        super.visitParameterList(parameterList);
    }

    private static boolean isVariableLengthParameterList(ParameterListTree parameterList) {
        SeparatedList parameters = parameterList.parameters();
        if (!parameters.isEmpty()) {
            ParameterTree lastParameter = (ParameterTree)parameters.get(parameters.size() - 1);
            return lastParameter.ellipsisToken() != null;
        }
        return false;
    }

    private static List<ParameterTree> getParametersToMove(ParameterListTree parameterList) {
        ArrayList parametersToMove = Lists.newArrayList();
        boolean metParamWithoutDefault = false;
        for (ParameterTree param : Lists.reverse((List)parameterList.parameters())) {
            boolean hasDefault;
            boolean bl = hasDefault = param.initValue() != null;
            if (!hasDefault && !metParamWithoutDefault) {
                metParamWithoutDefault = true;
                continue;
            }
            if (!hasDefault || !metParamWithoutDefault) continue;
            parametersToMove.add(param);
        }
        return Lists.reverse((List)parametersToMove);
    }

    private static String getNameListString(List<ParameterTree> params) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (ParameterTree parameter : params) {
            parameterNames.add("\"" + parameter.variableIdentifier().variableExpression().text() + "\"");
        }
        return Joiner.on((String)", ").join(parameterNames);
    }
}

