/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1125")
public class BooleanEqualityComparisonCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1125";
    private static final String MESSAGE = "Remove the literal \"%s\" boolean value.";
    private static final Tree.Kind[] BINARY_CONDITIONAL_KINDS = new Tree.Kind[]{Tree.Kind.CONDITIONAL_OR, Tree.Kind.ALTERNATIVE_CONDITIONAL_OR, Tree.Kind.CONDITIONAL_AND, Tree.Kind.ALTERNATIVE_CONDITIONAL_AND, Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.ALTERNATIVE_NOT_EQUAL_TO};

    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.check(tree.condition(), tree.falseExpression(), tree.trueExpression());
        super.visitConditionalExpression(tree);
    }

    public void visitPrefixExpression(UnaryExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            this.check(tree.expression());
        }
        super.visitPrefixExpression(tree);
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (tree.is(BINARY_CONDITIONAL_KINDS)) {
            this.check(tree.leftOperand(), tree.rightOperand());
        }
        super.visitBinaryExpression(tree);
    }

    private void check(ExpressionTree ... expressions) {
        for (ExpressionTree expression : expressions) {
            if (expression == null || !expression.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) continue;
            this.context().newIssue((PHPCheck)this, (Tree)expression, String.format(MESSAGE, ((LiteralTree)expression).value()));
        }
    }
}

