/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1605")
public class CallParentConstructorCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1605";
    private static final String MESSAGE = "Replace \"parent::%s(...)\" by \"parent::__construct(...)\".";
    private String superClass = null;

    public void visitClassDeclaration(ClassDeclarationTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS_DECLARATION})) {
            this.visitClass((ClassTree)tree);
        }
    }

    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.visitClass((ClassTree)tree);
    }

    private void visitClass(ClassTree tree) {
        MethodDeclarationTree constructor;
        if (tree.superClass() != null && (constructor = tree.fetchConstructor()) != null && CallParentConstructorCheck.isPHP5Constructor(constructor)) {
            this.superClass = tree.superClass().fullName();
            this.scan((Tree)constructor);
            this.superClass = null;
        }
    }

    public void visitFunctionCall(FunctionCallTree tree) {
        if (this.superClass != null && tree.callee().is(new Tree.Kind[]{Tree.Kind.CLASS_MEMBER_ACCESS})) {
            MemberAccessTree memberAccess = (MemberAccessTree)tree.callee();
            String memberName = CallParentConstructorCheck.getName(memberAccess.member());
            if (CallParentConstructorCheck.isParent(memberAccess.object()) && this.superClass.equalsIgnoreCase(memberName)) {
                this.context().newIssue((PHPCheck)this, (Tree)tree, String.format(MESSAGE, memberName));
            }
        }
        super.visitFunctionCall(tree);
    }

    private static boolean isPHP5Constructor(MethodDeclarationTree constructor) {
        return "__construct".equalsIgnoreCase(constructor.name().text());
    }

    @Nullable
    private static String getName(Tree member) {
        return member.is(new Tree.Kind[]{Tree.Kind.NAME_IDENTIFIER}) ? ((NameIdentifierTree)member).text() : null;
    }

    private static boolean isParent(ExpressionTree object) {
        return object.is(new Tree.Kind[]{Tree.Kind.NAMESPACE_NAME}) && "parent".equalsIgnoreCase(((NamespaceNameTree)object).fullName());
    }
}

