/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.declaration.TypeTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1200")
public class ClassCouplingCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1200";
    private static final String MESSAGE = "Split this class into smaller and more specialized ones to reduce its dependencies on other classes from %s to the maximum authorized %s or less.";
    public static final int DEFAULT = 20;
    private Deque<Set<String>> types = new ArrayDeque<Set<String>>();
    private static final Set<String> DOC_TAGS = ImmutableSet.of((Object)"@var", (Object)"@global", (Object)"@staticvar", (Object)"@throws", (Object)"@param", (Object)"@return", (Object[])new String[0]);
    private static final Set<String> EXCLUDED_TYPES = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
    @RuleProperty(key="max", defaultValue="20")
    public int max = 20;

    public void visitNewExpression(NewExpressionTree tree) {
        this.retrieveInstantiatedClassName(tree);
        super.visitNewExpression(tree);
    }

    public void visitClassDeclaration(ClassDeclarationTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS_DECLARATION})) {
            this.enterClass((ClassTree)tree);
        }
        super.visitClassDeclaration(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS_DECLARATION})) {
            this.leaveClass((ClassTree)tree);
        }
    }

    private void leaveClass(ClassTree tree) {
        int nbType = this.types.removeLast().size();
        if (nbType > this.max) {
            String message = String.format(MESSAGE, nbType, this.max);
            this.context().newIssue((PHPCheck)this, (Tree)tree.classToken(), message);
        }
    }

    private void enterClass(ClassTree tree) {
        this.types.addLast(new HashSet());
        this.retrieveCoupledTypes(tree);
    }

    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.enterClass((ClassTree)tree);
        super.visitAnonymousClass(tree);
        this.leaveClass((ClassTree)tree);
    }

    private void retrieveCoupledTypes(ClassTree classTree) {
        for (ClassMemberTree classMember : classTree.members()) {
            switch (classMember.getKind()) {
                case CLASS_PROPERTY_DECLARATION: 
                case CLASS_CONSTANT_PROPERTY_DECLARATION: {
                    this.retrieveTypeFromDoc(classMember);
                    break;
                }
                case METHOD_DECLARATION: {
                    this.retrieveTypeFromDoc(classMember);
                    this.retrieveTypeFromParameter((MethodDeclarationTree)classMember);
                    break;
                }
            }
        }
    }

    private void retrieveTypeFromParameter(MethodDeclarationTree methodDeclaration) {
        for (ParameterTree parameter : methodDeclaration.parameters().parameters()) {
            TypeTree type = parameter.type();
            if (type == null || !type.typeName().is(new Tree.Kind[]{Tree.Kind.NAMESPACE_NAME})) continue;
            this.addType(ClassCouplingCheck.getTypeName((NamespaceNameTree)type.typeName()));
        }
    }

    private void retrieveTypeFromDoc(ClassMemberTree varDeclaration) {
        SyntaxToken varDecToken = ((PHPTree)varDeclaration).getFirstToken();
        for (SyntaxTrivia comment : varDecToken.trivias()) {
            for (String line : comment.text().split("[\\n\\r\\u2028\\u2029]++")) {
                this.retrieveTypeFromCommentLine(line);
            }
        }
    }

    private void retrieveTypeFromCommentLine(String line) {
        String[] commentLine = line.trim().split("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]++");
        if (commentLine.length > 2 && DOC_TAGS.contains(commentLine[1])) {
            for (String type : commentLine[2].split("\\|")) {
                if (EXCLUDED_TYPES.contains(type = StringUtils.removeEnd((String)type, (String)"[]"))) continue;
                this.addType(type);
            }
        }
    }

    private void retrieveInstantiatedClassName(NewExpressionTree newExpression) {
        ExpressionTree expression = newExpression.expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.FUNCTION_CALL})) {
            ExpressionTree callee = ((FunctionCallTree)expression).callee();
            if (callee.is(new Tree.Kind[]{Tree.Kind.NAMESPACE_NAME})) {
                this.addType(ClassCouplingCheck.getTypeName((NamespaceNameTree)callee));
            }
        } else if (expression.is(new Tree.Kind[]{Tree.Kind.NAMESPACE_NAME})) {
            this.addType(ClassCouplingCheck.getTypeName((NamespaceNameTree)expression));
        }
    }

    private static String getTypeName(NamespaceNameTree namespaceName) {
        String prefix;
        String name = namespaceName.fullName();
        if (StringUtils.startsWithIgnoreCase((String)name, (String)(prefix = "namespace\\"))) {
            name = name.substring(prefix.length() - 1);
        }
        return name;
    }

    private void addType(String type) {
        if (!this.types.isEmpty()) {
            this.types.getLast().add(type);
        }
    }

    static {
        EXCLUDED_TYPES.addAll((Collection<String>)ImmutableSet.of((Object)"INTEGER", (Object)"INT", (Object)"DOUBLE", (Object)"FLOAT", (Object)"STRING", (Object)"ARRAY", (Object[])new String[]{"OBJECT", "BOOLEAN", "BOOL", "BINARY", "NULL", "MIXED"}));
    }
}

