/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.php.api.PHPKeyword;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.squidbridge.recognizer.CodeRecognizer;
import org.sonar.squidbridge.recognizer.ContainsDetector;
import org.sonar.squidbridge.recognizer.Detector;
import org.sonar.squidbridge.recognizer.EndWithDetector;
import org.sonar.squidbridge.recognizer.KeywordsDetector;
import org.sonar.squidbridge.recognizer.LanguageFootprint;

@Rule(key="S125")
public class CommentedOutCodeCheck
extends PHPVisitorCheck {
    public static final String KEY = "S125";
    private static final String MESSAGE = "Remove this commented out code.";
    private static final double THRESHOLD = 0.9;
    private final CodeRecognizer codeRecognizer = new CodeRecognizer(0.9, (LanguageFootprint)new PHPRecognizer());
    private final Pattern regexpToDivideStringByLine = Pattern.compile("(\r?\n)|(\r)");
    private SyntaxTrivia previousTrivia;

    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.previousTrivia = null;
        super.visitCompilationUnit(tree);
    }

    public void visitTrivia(SyntaxTrivia trivia) {
        block3: {
            block2: {
                super.visitTrivia(trivia);
                if (!CommentedOutCodeCheck.isInlineComment(trivia)) break block2;
                if (!this.isCommentedCode(CommentedOutCodeCheck.getContents(trivia.text())) || this.previousLineIsCommentedCode(trivia, this.previousTrivia)) break block3;
                this.reportIssue(trivia.line());
                break block3;
            }
            if (!CommentedOutCodeCheck.isPHPDoc(trivia)) {
                String[] lines = this.regexpToDivideStringByLine.split(CommentedOutCodeCheck.getContents(trivia.text()));
                for (int lineOffset = 0; lineOffset < lines.length; ++lineOffset) {
                    if (!this.isCommentedCode(lines[lineOffset])) continue;
                    this.reportIssue(trivia.line() + lineOffset);
                    break;
                }
            }
        }
        this.previousTrivia = trivia;
    }

    private void reportIssue(int line) {
        this.context().newLineIssue((PHPCheck)this, line, MESSAGE);
    }

    private boolean previousLineIsCommentedCode(SyntaxTrivia trivia, @Nullable SyntaxTrivia previousTrivia) {
        return previousTrivia != null && trivia.line() == previousTrivia.line() + 1 && this.isCommentedCode(previousTrivia.text());
    }

    private boolean isCommentedCode(String line) {
        return this.codeRecognizer.isLineOfCode(line);
    }

    private static boolean isInlineComment(SyntaxTrivia trivia) {
        return trivia.text().startsWith("//");
    }

    private static boolean isPHPDoc(SyntaxTrivia trivia) {
        return trivia.text().startsWith("/**");
    }

    private static String getContents(String comment) {
        if (comment.startsWith("//")) {
            return comment.substring(2);
        }
        if (comment.charAt(0) == '#') {
            return comment.substring(1);
        }
        return comment.substring(2, comment.length() - 2);
    }

    private static class PHPRecognizer
    implements LanguageFootprint {
        private PHPRecognizer() {
        }

        public Set<Detector> getDetectors() {
            return ImmutableSet.of((Object)new EndWithDetector(0.95, new char[]{'}', ';', '{'}), (Object)new KeywordsDetector(0.3, PHPKeyword.getKeywordValues()), (Object)new ContainsDetector(0.95, new String[]{"*=", "/=", "%=", "+=", "-=", "<<=", ">>=", "&=", "^=", "|="}), (Object)new ContainsDetector(0.95, new String[]{"!=", "!=="}));
        }
    }
}

