/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassPropertyDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ConstantDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S115")
public class ConstantNameCheck
extends PHPVisitorCheck {
    public static final String KEY = "S115";
    private static final String MESSAGE = "Rename this constant \"%s\" to match the regular expression %s.";
    public static final String DEFAULT = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", defaultValue="^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$")
    String format = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";

    public void init() {
        this.pattern = Pattern.compile(this.format);
    }

    public void visitFunctionCall(FunctionCallTree functionCall) {
        ExpressionTree firstArgument;
        SeparatedList arguments;
        ExpressionTree callee = functionCall.callee();
        if (callee.is(new Tree.Kind[]{Tree.Kind.NAMESPACE_NAME}) && "define".equals(((NamespaceNameTree)callee).fullName()) && !(arguments = functionCall.arguments()).isEmpty() && (firstArgument = (ExpressionTree)arguments.get(0)).is(new Tree.Kind[]{Tree.Kind.REGULAR_STRING_LITERAL})) {
            String constantName = ((LiteralTree)firstArgument).value();
            this.checkConstantName((Tree)firstArgument, constantName.substring(1, constantName.length() - 1));
        }
        super.visitFunctionCall(functionCall);
    }

    public void visitClassPropertyDeclaration(ClassPropertyDeclarationTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS_CONSTANT_PROPERTY_DECLARATION})) {
            this.checkDeclarations((SeparatedList<VariableDeclarationTree>)tree.declarations());
        }
        super.visitClassPropertyDeclaration(tree);
    }

    public void visitConstDeclaration(ConstantDeclarationTree tree) {
        this.checkDeclarations((SeparatedList<VariableDeclarationTree>)tree.declarations());
        super.visitConstDeclaration(tree);
    }

    private void checkDeclarations(SeparatedList<VariableDeclarationTree> declarations) {
        for (VariableDeclarationTree declaration : declarations) {
            String constantName = declaration.identifier().text();
            this.checkConstantName((Tree)declaration.identifier(), constantName);
        }
    }

    private void checkConstantName(Tree tree, String constName) {
        if (!this.pattern.matcher(constName).matches()) {
            this.context().newIssue((PHPCheck)this, tree, String.format(MESSAGE, constName, this.format));
        }
    }
}

