/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1600")
public class DeprecatedPredefinedVariablesUseCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1600";
    private static final String MESSAGE = "Replace this use of the deprecated \"%s\" variable with \"%s\".";

    public void visitVariableIdentifier(VariableIdentifierTree tree) {
        this.checkVariable(tree.variableExpression().token());
        super.visitVariableIdentifier(tree);
    }

    private void checkVariable(SyntaxToken variable) {
        String name = variable.text();
        if (CheckUtils.PREDEFINED_VARIABLES.containsKey((Object)name)) {
            String message = String.format(MESSAGE, name, CheckUtils.PREDEFINED_VARIABLES.get((Object)name));
            this.context().newIssue((PHPCheck)this, (Tree)variable, message);
        }
    }

    public void visitMemberAccess(MemberAccessTree tree) {
    }
}

