/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2043")
public class DirectlyAccessingSuperGlobalCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Do not access \"%s\" directly.";
    public static final String KEY = "S2043";

    public void visitVariableIdentifier(VariableIdentifierTree tree) {
        this.checkVariable(tree.variableExpression().token());
        super.visitVariableIdentifier(tree);
    }

    private void checkVariable(SyntaxToken variable) {
        String name = variable.text();
        if (CheckUtils.PREDEFINED_VARIABLES.values().contains((Object)name)) {
            this.context().newIssue((PHPCheck)this, (Tree)variable, String.format(MESSAGE, name));
        }
    }
}

