/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.AbstractDuplicateBranchCheck;
import org.sonar.php.checks.utils.Equality;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.SwitchCaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;

@Rule(key="S1871")
public class DuplicateBranchImplementationCheck
extends AbstractDuplicateBranchCheck {
    public static final String KEY = "S1871";
    private static final String MESSAGE = "This %s's code block is the same as the block for the %s on line %s.";
    private static final String MESSAGE_CONDITIONAL = "This conditional operation returns the same value whether the condition is \"true\" or \"false\".";

    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        if (Equality.areSyntacticallyEquivalent((Tree)tree.trueExpression(), (Tree)tree.falseExpression())) {
            this.context().newIssue((PHPCheck)this, (Tree)tree, MESSAGE_CONDITIONAL);
        }
        super.visitConditionalExpression(tree);
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        super.visitSwitchStatement(tree);
        ArrayList<Branch> casesList = new ArrayList<Branch>();
        for (SwitchCaseClauseTree clause : tree.cases()) {
            if (!clause.is(new Tree.Kind[]{Tree.Kind.CASE_CLAUSE})) continue;
            casesList.add(new Branch((Tree)clause, clause.statements()));
        }
        this.checkForEquality("case", casesList);
    }

    public void visitIfStatement(IfStatementTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) && !this.checkedIfStatements.contains(tree)) {
            ArrayList<Branch> branchesList = new ArrayList<Branch>();
            for (Tree clause : this.getClauses(tree)) {
                ElseClauseTree elseClause;
                if (clause.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
                    IfStatementTree ifStatementTree = (IfStatementTree)clause;
                    branchesList.add(new Branch(clause, ifStatementTree.statements()));
                    continue;
                }
                if (clause.is(new Tree.Kind[]{Tree.Kind.ELSEIF_CLAUSE})) {
                    ElseifClauseTree elseifClauseTree = (ElseifClauseTree)clause;
                    branchesList.add(new Branch(clause, elseifClauseTree.statements()));
                    continue;
                }
                if (!clause.is(new Tree.Kind[]{Tree.Kind.ELSE_CLAUSE}) || ((StatementTree)(elseClause = (ElseClauseTree)clause).statements().get(0)).is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) continue;
                branchesList.add(new Branch(clause, elseClause.statements()));
            }
            this.checkForEquality("branch", branchesList);
        }
        super.visitIfStatement(tree);
    }

    private void checkForEquality(String branchType, List<Branch> list) {
        block0: for (int i = 1; i < list.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (!DuplicateBranchImplementationCheck.areSyntacticallyEquivalent(list.get((int)i).body, list.get((int)j).body)) continue;
                this.raiseIssue(branchType, list.get((int)j).clause, list.get((int)i).clause);
                continue block0;
            }
        }
    }

    private static boolean areSyntacticallyEquivalent(List<StatementTree> list1, List<StatementTree> list2) {
        boolean bothEmpty = list1.isEmpty() && list2.isEmpty();
        return !bothEmpty && Equality.areSyntacticallyEquivalent(list1.iterator(), list2.iterator());
    }

    @Override
    protected void raiseIssue(String branchType, Tree duplicatedTree, Tree duplicatingTree) {
        String message = String.format(MESSAGE, branchType, branchType, ((PHPTree)duplicatedTree).getLine());
        this.context().newIssue((PHPCheck)this, duplicatingTree, message).secondary(duplicatedTree, null);
    }

    private static class Branch {
        Tree clause;
        List<StatementTree> body;

        public Branch(Tree clause, List<StatementTree> body) {
            this.clause = clause;
            this.body = body;
        }
    }
}

