/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableSet;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.FunctionUsageCheck;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;

@Rule(key="S2041")
public class EchoWithParenthesisCheck
extends FunctionUsageCheck {
    public static final String KEY = "S2041";
    private static final String MESSAGE = "Remove the parentheses from this \"echo\" call.";

    @Override
    protected ImmutableSet<String> functionNames() {
        return ImmutableSet.of((Object)"echo");
    }

    @Override
    protected void createIssue(FunctionCallTree tree) {
        if (EchoWithParenthesisCheck.isParenthesized(tree)) {
            this.context().newIssue((PHPCheck)this, (Tree)tree.callee(), MESSAGE);
        }
    }

    private static boolean isParenthesized(FunctionCallTree tree) {
        return tree.arguments().size() == 1 && ((ExpressionTree)tree.arguments().get(0)).is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION});
    }
}

