/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S126")
public class ElseIfWithoutElseCheck
extends PHPVisitorCheck {
    public static final String KEY = "S126";
    private static final String MESSAGE = "Add the missing \"else\" clause.";

    public void visitIfStatement(IfStatementTree tree) {
        super.visitIfStatement(tree);
        List elseifClauses = tree.elseifClauses();
        if (!elseifClauses.isEmpty() && tree.elseClause() == null) {
            ElseifClauseTree lastElseIf = (ElseifClauseTree)elseifClauses.get(elseifClauses.size() - 1);
            this.context().newIssue((PHPCheck)this, (Tree)lastElseIf.elseifToken(), MESSAGE);
        }
    }

    public void visitElseClause(ElseClauseTree tree) {
        IfStatementTree nestedIf;
        super.visitElseClause(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.ELSE_CLAUSE}) && ((StatementTree)tree.statements().get(0)).is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) && (nestedIf = (IfStatementTree)tree.statements().get(0)).elseClause() == null && nestedIf.elseifClauses().isEmpty()) {
            this.context().newIssue((PHPCheck)this, (Tree)tree.elseToken(), (Tree)nestedIf.ifToken(), MESSAGE);
        }
    }
}

