/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.tree.statement.UseTraitDeclarationTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S108")
public class EmptyNestedBlockCheck
extends PHPVisitorCheck {
    public static final String KEY = "S108";
    private static final String MESSAGE = "Either remove or fill this block of code.";

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        if (tree.body().is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            super.visitBlock((BlockTree)tree.body());
        }
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        super.visitBlock(tree.body());
    }

    public void visitBlock(BlockTree tree) {
        super.visitBlock(tree);
        if (EmptyNestedBlockCheck.isEmpty(tree.statements(), tree.closeCurlyBraceToken())) {
            this.context().newIssue((PHPCheck)this, (Tree)tree, MESSAGE);
        }
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        super.visitSwitchStatement(tree);
        if (EmptyNestedBlockCheck.isEmpty(tree.cases(), tree.closeCurlyBraceToken())) {
            this.context().newIssue((PHPCheck)this, (Tree)tree.openCurlyBraceToken(), (Tree)tree.closeCurlyBraceToken(), MESSAGE);
        }
    }

    public void visitUseTraitDeclaration(UseTraitDeclarationTree tree) {
        super.visitUseTraitDeclaration(tree);
        if (EmptyNestedBlockCheck.isEmpty(tree.adaptations(), tree.closeCurlyBraceToken())) {
            this.context().newIssue((PHPCheck)this, (Tree)tree.openCurlyBraceToken(), (Tree)tree.closeCurlyBraceToken(), MESSAGE);
        }
    }

    private static <T extends Tree> boolean isEmpty(List<T> statements, @Nullable SyntaxToken lastToken) {
        return statements.isEmpty() && lastToken != null && lastToken.trivias().isEmpty();
    }
}

