/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1799")
public class ExitOrDieUsageCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1799";
    public static final String MESSAGE = "Remove this \"%s()\" call or ensure it is really required";

    public void visitFunctionCall(FunctionCallTree tree) {
        if (CheckUtils.isExitExpression(tree)) {
            String callee = tree.callee().toString();
            this.context().newIssue((PHPCheck)this, (Tree)tree.callee(), String.format(MESSAGE, callee));
        }
        super.visitFunctionCall(tree);
    }
}

