/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S1067")
public class ExpressionComplexityCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S1067";
    private static final String MESSAGE = "Reduce the number of conditional operators (%s) used in the expression (maximum allowed %s).";
    public static final int DEFAULT = 3;
    private Deque<ComplexExpression> expressions = new ArrayDeque<ComplexExpression>();
    @RuleProperty(defaultValue="3")
    public int max = 3;
    private static final Tree.Kind[] COMPLEXITY_INCREMENTING_KINDS = new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.ALTERNATIVE_CONDITIONAL_AND, Tree.Kind.ALTERNATIVE_CONDITIONAL_OR};
    private static final Tree.Kind[] NESTING_KINDS = new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.FUNCTION_CALL};

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object[])COMPLEXITY_INCREMENTING_KINDS).add((Object[])NESTING_KINDS).build();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            this.expressions.clear();
        }
        if (tree.is(NESTING_KINDS)) {
            this.expressions.push(new ComplexExpression());
        } else {
            this.expressions.peek().increment(tree);
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(NESTING_KINDS)) {
            this.expressions.pop();
        } else {
            ComplexExpression currentExpression = this.expressions.peek();
            if (tree.equals(currentExpression.root)) {
                if (currentExpression.complexity > this.max) {
                    String message = String.format(MESSAGE, currentExpression.complexity, this.max);
                    int cost = currentExpression.complexity - this.max;
                    this.context().newIssue((PHPCheck)this, tree, message).cost((double)cost);
                }
                this.expressions.pop();
                this.expressions.push(new ComplexExpression());
            }
        }
    }

    private static class ComplexExpression {
        private Tree root;
        private int complexity = 0;

        private ComplexExpression() {
        }

        public void increment(Tree tree) {
            if (this.root == null) {
                this.root = tree;
            }
            ++this.complexity;
        }
    }
}

