/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.api.CharsetAwareVisitor;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1451")
public class FileHeaderCheck
extends PHPVisitorCheck
implements CharsetAwareVisitor {
    public static final String KEY = "S1451";
    private static final String MESSAGE = "Add or update the header of this file.";
    private static final String DEFAULT_HEADER_FORMAT = "";
    private static final Pattern PHP_OPEN_TAG = Pattern.compile("(?i)(?:<\\?(?:php|=|)|<%)");
    @RuleProperty(key="headerFormat", defaultValue="", type="TEXT")
    public String headerFormat = "";
    private Charset charset;
    private String[] expectedLines;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void init() {
        this.expectedLines = this.headerFormat.split("(?:\r)?\n|\r");
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        List lines;
        try {
            lines = Files.readLines((File)this.context().file(), (Charset)this.charset);
        }
        catch (IOException e) {
            throw new IllegalStateException("Check S1451: Can't read the file", e);
        }
        if (!lines.isEmpty() && !FileHeaderCheck.matches(this.expectedLines, lines)) {
            this.context().newFileIssue((PHPCheck)this, MESSAGE);
        }
    }

    private static boolean matches(String[] expectedLines, List<String> lines) {
        boolean result;
        if (PHP_OPEN_TAG.matcher(lines.get(0)).matches()) {
            lines.remove(0);
        }
        if (expectedLines.length <= lines.size()) {
            result = true;
            Iterator<String> it = lines.iterator();
            for (String expectedLine : expectedLines) {
                String line = it.next();
                if (line.equals(expectedLine)) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }
}

