/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.api.PHPKeyword;
import org.sonar.php.checks.formatting.ControlStructureSpacingCheck;
import org.sonar.php.checks.formatting.CurlyBraceCheck;
import org.sonar.php.checks.formatting.ExtendsImplementsLineCheck;
import org.sonar.php.checks.formatting.FormattingCheck;
import org.sonar.php.checks.formatting.FunctionSpacingCheck;
import org.sonar.php.checks.formatting.IndentationCheck;
import org.sonar.php.checks.formatting.NamespaceAndUseStatementCheck;
import org.sonar.php.checks.formatting.PunctuatorSpacingCheck;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S1808")
public class FormattingStandardCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1808";
    private static final FormattingCheck[] SUB_CHECKS = new FormattingCheck[]{new NamespaceAndUseStatementCheck(), new CurlyBraceCheck(), new PunctuatorSpacingCheck(), new FunctionSpacingCheck(), new ControlStructureSpacingCheck(), new IndentationCheck(), new ExtendsImplementsLineCheck()};
    @RuleProperty(key="namespace_blank_line", defaultValue="true", type="BOOLEAN")
    public boolean hasNamespaceBlankLine = true;
    @RuleProperty(key="use_after_namespace", defaultValue="true", type="BOOLEAN")
    public boolean isUseAfterNamespace = true;
    @RuleProperty(key="use_blank_line", defaultValue="true", type="BOOLEAN")
    public boolean hasUseBlankLine = true;
    @RuleProperty(key="open_curly_brace_classes_functions", defaultValue="true", type="BOOLEAN")
    public boolean isOpenCurlyBraceForClassAndFunction = true;
    @RuleProperty(key="open_curly_brace_control_structures", defaultValue="true", type="BOOLEAN")
    public boolean isOpenCurlyBraceForControlStructures = true;
    @RuleProperty(key="closing_curly_brace", defaultValue="true", type="BOOLEAN")
    public boolean isClosingCurlyNextToKeyword = true;
    @RuleProperty(key="one_space_after", defaultValue="true", type="BOOLEAN")
    public boolean isOneSpaceBetweenRParentAndLCurly = true;
    @RuleProperty(key="one_space_before", defaultValue="true", type="BOOLEAN")
    public boolean isOneSpaceBetweenKeywordAndNextToken = true;
    @RuleProperty(key="one_space_for", defaultValue="true", type="BOOLEAN")
    public boolean isOneSpaceAfterForLoopSemicolon = true;
    @RuleProperty(key="space_comma", defaultValue="true", type="BOOLEAN")
    public boolean isOneSpaceAfterComma = true;
    @RuleProperty(key="no_space_method_name", defaultValue="true", type="BOOLEAN")
    public boolean isNoSpaceAfterMethodName = true;
    @RuleProperty(key="foreach_space", defaultValue="true", type="BOOLEAN")
    public boolean isSpaceForeachStatement = true;
    @RuleProperty(key="no_space", defaultValue="true", type="BOOLEAN")
    public boolean isNoSpaceParenthesis = true;
    @RuleProperty(key="closure_format", defaultValue="true", type="BOOLEAN")
    public boolean isClosureSpacing = true;
    @RuleProperty(key="function_declaration_arguments_indentation", defaultValue="true", type="BOOLEAN")
    public boolean isMethodArgumentsIndentation = true;
    @RuleProperty(key="function_calls_arguments_indentation", defaultValue="true", type="BOOLEAN")
    public boolean isFunctionCallsArgumentsIndentation = true;
    @RuleProperty(key="interfaces_indentation", defaultValue="true", type="BOOLEAN")
    public boolean isInterfacesIndentation = true;
    @RuleProperty(key="extends_implements_line", defaultValue="true", type="BOOLEAN")
    public boolean isExtendsAndImplementsLine = true;
    private static final List<String> INTERNAL_FUNCTIONS = ImmutableList.of((Object)PHPKeyword.ECHO.getValue(), (Object)PHPKeyword.ISSET.getValue(), (Object)PHPKeyword.EMPTY.getValue(), (Object)PHPKeyword.INCLUDE_ONCE.getValue(), (Object)PHPKeyword.INCLUDE.getValue(), (Object)PHPKeyword.EVAL.getValue(), (Object)PHPKeyword.REQUIRE.getValue(), (Object)PHPKeyword.REQUIRE_ONCE.getValue(), (Object)PHPKeyword.CLONE.getValue(), (Object)PHPKeyword.PRINT.getValue(), (Object)PHPKeyword.HALT_COMPILER.getValue(), (Object)PHPKeyword.DIE.getValue(), (Object[])new String[]{PHPKeyword.EXIT.getValue()});

    public boolean isInternalFunction(ExpressionTree callee) {
        String calleeString = callee.toString().toLowerCase(Locale.ROOT);
        return INTERNAL_FUNCTIONS.contains(calleeString);
    }

    public void visitScript(ScriptTree tree) {
        for (FormattingCheck subCheck : SUB_CHECKS) {
            subCheck.checkFormat(this, tree);
        }
    }

    public void reportIssue(String msg, Tree ... issueLocations) {
        PreciseIssue issue = this.context().newIssue((PHPCheck)this, issueLocations[0], msg);
        for (int i = 1; i < issueLocations.length; ++i) {
            issue.secondary(issueLocations[i], null);
        }
    }
}

