/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.Sets;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2007")
public class FunctionDefineOutsideClassCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2007";
    private static final String MESSAGE = "Move this %s into a class.";
    private final Set<String> globalVariableNames = Sets.newHashSet();

    public void visitScript(ScriptTree tree) {
        this.globalVariableNames.clear();
        super.visitScript(tree);
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.context().newIssue((PHPCheck)this, (Tree)tree.name(), String.format(MESSAGE, "function"));
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        String varName;
        super.visitAssignmentExpression(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && tree.variable().is(new Tree.Kind[]{Tree.Kind.VARIABLE_IDENTIFIER}) && !FunctionDefineOutsideClassCheck.isSuperGlobal(varName = ((VariableIdentifierTree)tree.variable()).variableExpression().text()) && !this.globalVariableNames.contains(varName)) {
            this.context().newIssue((PHPCheck)this, (Tree)tree.variable(), String.format(MESSAGE, "variable"));
            this.globalVariableNames.add(varName);
        }
    }

    private static boolean isSuperGlobal(String varName) {
        return "$GLOBALS".equals(varName) || CheckUtils.PREDEFINED_VARIABLES.values().contains((Object)varName);
    }
}

