/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableList;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S100")
public class FunctionNameCheck
extends PHPVisitorCheck {
    public static final String KEY = "S100";
    private static final String MESSAGE = "Rename function \"%s\" to match the regular expression %s.";
    private static final ImmutableList<String> MAGIC_METHODS = ImmutableList.of((Object)"__construct", (Object)"__destruct", (Object)"__call", (Object)"__callStatic", (Object)"__callStatic", (Object)"__get", (Object)"__set", (Object)"__isset", (Object)"__unset", (Object)"__sleep", (Object)"__wakeup", (Object)"__toString", (Object[])new String[]{"__invoke", "__set_state", "__clone", "__clone", "__debugInfo"});
    public static final String DEFAULT = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", defaultValue="^[a-z][a-zA-Z0-9]*$")
    String format = "^[a-z][a-zA-Z0-9]*$";

    public void init() {
        this.pattern = Pattern.compile(this.format);
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        if (!CheckUtils.isOverriding(tree)) {
            this.check(tree.name());
        }
        super.visitMethodDeclaration(tree);
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.check(tree.name());
        super.visitFunctionDeclaration(tree);
    }

    private void check(NameIdentifierTree name) {
        String functionName = name.text();
        if (!this.pattern.matcher(functionName).matches() && !MAGIC_METHODS.contains((Object)functionName)) {
            this.context().newIssue((PHPCheck)this, (Tree)name, String.format(MESSAGE, functionName, this.format));
        }
    }
}

