/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2068")
public class HardCodedCredentialsCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2068";
    private static final String MESSAGE = "Remove this hard-coded password.";
    private static final Pattern PASSWORD_LITERAL_PATTERN = Pattern.compile("password=..", 2);
    private static final Pattern PASSWORD_VARIABLE_PATTERN = Pattern.compile("password", 2);

    public void visitLiteral(LiteralTree literal) {
        if (literal.is(new Tree.Kind[]{Tree.Kind.REGULAR_STRING_LITERAL}) && PASSWORD_LITERAL_PATTERN.matcher(literal.token().text()).find()) {
            this.addIssue((Tree)literal);
        }
        super.visitLiteral(literal);
    }

    public void visitVariableDeclaration(VariableDeclarationTree declaration) {
        String identifier = declaration.identifier().text();
        this.checkVariable((Tree)declaration.identifier(), identifier, (Tree)declaration.initValue());
        super.visitVariableDeclaration(declaration);
    }

    public void visitAssignmentExpression(AssignmentExpressionTree assignment) {
        SyntaxToken lastToken = ((PHPTree)assignment.variable()).getLastToken();
        String variableName = lastToken.text();
        this.checkVariable((Tree)lastToken, variableName, (Tree)assignment.value());
        super.visitAssignmentExpression(assignment);
    }

    private void checkVariable(Tree tree, String identifier, @Nullable Tree value) {
        if (value != null && value.is(new Tree.Kind[]{Tree.Kind.REGULAR_STRING_LITERAL}) && PASSWORD_VARIABLE_PATTERN.matcher(identifier).find()) {
            this.addIssue(tree);
        }
    }

    private void addIssue(Tree tree) {
        this.context().newIssue((PHPCheck)this, tree, MESSAGE);
    }
}

