/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.Equality;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1764")
public class IdenticalOperandsInBinaryExpressionCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1764";
    private static final String MESSAGE = "Identical sub-expressions on both sides of operator \"%s\"";
    private static final Set<String> EXCLUDED_OPERATORS = ImmutableSet.of((Object)"*", (Object)"+", (Object)".");

    public void visitBinaryExpression(BinaryExpressionTree binaryExp) {
        String operator = binaryExp.operator().text();
        if (!EXCLUDED_OPERATORS.contains(operator) && IdenticalOperandsInBinaryExpressionCheck.hasIdenticalOperands(binaryExp) && !IdenticalOperandsInBinaryExpressionCheck.isLeftShiftBy1(binaryExp)) {
            this.context().newIssue((PHPCheck)this, (Tree)binaryExp.rightOperand(), String.format(MESSAGE, operator)).secondary((Tree)binaryExp.leftOperand(), null);
        }
        super.visitBinaryExpression(binaryExp);
    }

    private static boolean hasIdenticalOperands(BinaryExpressionTree binaryExp) {
        return Equality.areSyntacticallyEquivalent((Tree)binaryExp.leftOperand(), (Tree)binaryExp.rightOperand());
    }

    private static boolean isLeftShiftBy1(BinaryExpressionTree binaryExp) {
        if (binaryExp.is(new Tree.Kind[]{Tree.Kind.LEFT_SHIFT}) && binaryExp.rightOperand().is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL})) {
            LiteralTree rightOperand = (LiteralTree)binaryExp.rightOperand();
            return "1".equals(rightOperand.token().text());
        }
        return false;
    }
}

