/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.TokenVisitor;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.php.api.tree.statement.DeclareStatementTree;
import org.sonar.plugins.php.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.NamespaceStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.tree.statement.TryStatementTree;
import org.sonar.plugins.php.api.tree.statement.UseTraitDeclarationTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1105")
public class LeftCurlyBraceEndsLineCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1105";
    private static final String MESSAGE = "Move this open curly brace to the end of the previous line.";

    public void visitClassDeclaration(ClassDeclarationTree tree) {
        super.visitClassDeclaration(tree);
        this.checkClass((ClassTree)tree);
    }

    public void visitAnonymousClass(AnonymousClassTree tree) {
        super.visitAnonymousClass(tree);
        this.checkClass((ClassTree)tree);
    }

    private void checkClass(ClassTree tree) {
        TokenVisitor tokenVisitor = new TokenVisitor((Tree)tree);
        this.checkOpenCurlyBrace(tree.openCurlyBraceToken(), tree.closeCurlyBraceToken(), tokenVisitor.prevToken(tree.openCurlyBraceToken()), tokenVisitor.nextToken(tree.openCurlyBraceToken()));
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        super.visitFunctionDeclaration(tree);
        this.checkBlock((Tree)tree.body(), LeftCurlyBraceEndsLineCheck.getLastToken((Tree)tree.parameters()));
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        super.visitFunctionExpression(tree);
        this.checkBlock((Tree)tree.body(), LeftCurlyBraceEndsLineCheck.getLastToken((Tree)tree.parameters()));
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        super.visitMethodDeclaration(tree);
        this.checkBlock(tree.body(), LeftCurlyBraceEndsLineCheck.getLastToken((Tree)tree.parameters()));
    }

    public void visitUseTraitDeclaration(UseTraitDeclarationTree tree) {
        super.visitUseTraitDeclaration(tree);
        if (tree.openCurlyBraceToken() != null) {
            TokenVisitor tokenVisitor = new TokenVisitor((Tree)tree);
            this.checkOpenCurlyBrace(tree.openCurlyBraceToken(), tree.closeCurlyBraceToken(), tokenVisitor.prevToken(tree.openCurlyBraceToken()), tokenVisitor.nextToken(tree.openCurlyBraceToken()));
        }
    }

    public void visitDeclareStatement(DeclareStatementTree tree) {
        super.visitDeclareStatement(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.DECLARE_STATEMENT}) && tree.statements().size() == 1) {
            this.checkBlock((Tree)tree.statements().get(0), tree.closeParenthesisToken());
        }
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        super.visitSwitchStatement(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.SWITCH_STATEMENT})) {
            TokenVisitor tokenVisitor = new TokenVisitor((Tree)tree);
            this.checkOpenCurlyBrace(tree.openCurlyBraceToken(), tree.closeCurlyBraceToken(), tokenVisitor.prevToken(tree.openCurlyBraceToken()), tokenVisitor.nextToken(tree.openCurlyBraceToken()));
        }
    }

    public void visitIfStatement(IfStatementTree tree) {
        super.visitIfStatement(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            this.checkBlock((Tree)tree.statements().get(0), LeftCurlyBraceEndsLineCheck.getLastToken((Tree)tree.condition()));
        }
    }

    public void visitElseifClause(ElseifClauseTree tree) {
        super.visitElseifClause(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.ELSEIF_CLAUSE})) {
            this.checkBlock((Tree)tree.statements().get(0), LeftCurlyBraceEndsLineCheck.getLastToken((Tree)tree.condition()));
        }
    }

    public void visitElseClause(ElseClauseTree tree) {
        super.visitElseClause(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.ELSE_CLAUSE})) {
            this.checkBlock((Tree)tree.statements().get(0), LeftCurlyBraceEndsLineCheck.getLastToken((Tree)tree.elseToken()));
        }
    }

    public void visitForStatement(ForStatementTree tree) {
        super.visitForStatement(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.FOR_STATEMENT})) {
            this.checkBlock((Tree)tree.statements().get(0), tree.closeParenthesisToken());
        }
    }

    public void visitForEachStatement(ForEachStatementTree tree) {
        super.visitForEachStatement(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.FOREACH_STATEMENT})) {
            this.checkBlock((Tree)tree.statements().get(0), tree.closeParenthesisToken());
        }
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        super.visitDoWhileStatement(tree);
        this.checkBlock((Tree)tree.statement(), tree.doToken());
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        super.visitWhileStatement(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.WHILE_STATEMENT})) {
            this.checkBlock((Tree)tree.statements().get(0), LeftCurlyBraceEndsLineCheck.getLastToken((Tree)tree.condition()));
        }
    }

    public void visitCatchBlock(CatchBlockTree tree) {
        super.visitCatchBlock(tree);
        this.checkBlock((Tree)tree.block(), tree.closeParenthesisToken());
    }

    public void visitTryStatement(TryStatementTree tree) {
        super.visitTryStatement(tree);
        this.checkBlock((Tree)tree.block(), tree.tryToken());
        if (tree.finallyToken() != null) {
            this.checkBlock((Tree)tree.finallyBlock(), tree.finallyToken());
        }
    }

    public void visitNamespaceStatement(NamespaceStatementTree tree) {
        super.visitNamespaceStatement(tree);
        if (tree.openCurlyBrace() != null) {
            TokenVisitor tokenVisitor = new TokenVisitor((Tree)tree);
            this.checkOpenCurlyBrace((SyntaxToken)tree.openCurlyBrace(), (SyntaxToken)tree.closeCurlyBrace(), tokenVisitor.prevToken((SyntaxToken)tree.openCurlyBrace()), tokenVisitor.nextToken((SyntaxToken)tree.openCurlyBrace()));
        }
    }

    private void checkBlock(Tree body, SyntaxToken prevToken) {
        if (body.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            BlockTree blockTree = (BlockTree)body;
            SyntaxToken nextToken = LeftCurlyBraceEndsLineCheck.getFirstToken(blockTree.statements());
            if (nextToken == null) {
                nextToken = blockTree.closeCurlyBraceToken();
            }
            this.checkOpenCurlyBrace(blockTree.openCurlyBraceToken(), blockTree.closeCurlyBraceToken(), prevToken, nextToken);
        }
    }

    private void checkOpenCurlyBrace(SyntaxToken lBrace, SyntaxToken rBrace, SyntaxToken prevToken, SyntaxToken nextToken) {
        int leftBraceLine = lBrace.line();
        if (leftBraceLine == rBrace.line()) {
            return;
        }
        if (leftBraceLine != prevToken.line() || leftBraceLine == nextToken.line()) {
            this.context().newIssue((PHPCheck)this, (Tree)lBrace, MESSAGE);
        }
    }

    private static SyntaxToken getLastToken(Tree tree) {
        return ((PHPTree)tree).getLastToken();
    }

    private static SyntaxToken getFirstToken(List<StatementTree> statements) {
        SyntaxToken nextToken = null;
        for (StatementTree statement : statements) {
            if (statement.is(new Tree.Kind[]{Tree.Kind.INLINE_HTML})) continue;
            nextToken = LeftCurlyBraceEndsLineCheck.getFirstToken((Tree)statement);
            break;
        }
        return nextToken;
    }

    private static SyntaxToken getFirstToken(Tree tree) {
        return ((PHPTree)tree).getFirstToken();
    }
}

