/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.api.CharsetAwareVisitor;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S103")
public class LineLengthCheck
extends PHPVisitorCheck
implements CharsetAwareVisitor {
    public static final String KEY = "S103";
    private static final String MESSAGE = "Split this %s characters long line (which is greater than %s authorized).";
    public static final int DEFAULT = 120;
    private Charset charset;
    @RuleProperty(key="maximumLineLength", defaultValue="120")
    public int maximumLineLength = 120;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        List lines;
        try {
            lines = Files.readLines((File)this.context().file(), (Charset)this.charset);
        }
        catch (IOException e) {
            throw new IllegalStateException("Check S103: Can't read the file", e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            if (line.length() <= this.maximumLineLength) continue;
            String message = String.format(MESSAGE, line.length(), this.maximumLineLength);
            this.context().newLineIssue((PHPCheck)this, i + 1, message);
        }
    }
}

